/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.error;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

public abstract class ErrorResponse {
    private static final Log LOG = Logging.getLog(ErrorResponse.class);
    private String errorDescription;
    private String errorUri;

    public abstract String getErrorCode();

    public abstract String getState();

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }

    public String toQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            queryStringBuilder.append("error=").append(this.getErrorCode());
            if (this.errorDescription != null && !this.errorDescription.isEmpty()) {
                queryStringBuilder.append("&error_description=").append(URLEncoder.encode(this.errorDescription, "UTF-8"));
            }
            if (this.errorUri != null && !this.errorUri.isEmpty()) {
                queryStringBuilder.append("&error_uri=").append(URLEncoder.encode(this.errorUri, "UTF-8"));
            }
            if (this.getState() != null && !this.getState().isEmpty()) {
                queryStringBuilder.append("&state=").append(this.getState());
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
        return queryStringBuilder.toString();
    }

    public String toJSonString() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("error", (Object)this.getErrorCode());
            if (this.errorDescription != null && !this.errorDescription.isEmpty()) {
                jsonObj.put("error_description", (Object)this.errorDescription);
            }
            if (this.errorUri != null && !this.errorUri.isEmpty()) {
                jsonObj.put("error_uri", (Object)this.errorUri);
            }
            if (this.getState() != null && !this.getState().isEmpty()) {
                jsonObj.put("state", (Object)this.getState());
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
        return jsonObj.toString();
    }
}

