/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapAttributesList;
import org.gluu.site.ldap.persistence.annotation.LdapCustomObjectClass;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.oxauth.model.common.CustomAttribute;
import org.xdi.oxauth.model.exception.InvalidClaimException;

@LdapEntry
@LdapObjectClass(values={"top"})
public class SimpleUser
implements Serializable {
    private static final long serialVersionUID = -1634191420188575733L;
    @LdapDN
    private String dn;
    @LdapAttribute(name="uid")
    private String userId;
    @LdapAttribute(name="oxAuthPersistentJWT")
    private String[] oxAuthPersistentJwt;
    @LdapAttributesList(name="name", value="values", sortByName=true)
    private List<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();
    @LdapCustomObjectClass
    private String[] customObjectClasses;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String[] getOxAuthPersistentJwt() {
        return this.oxAuthPersistentJwt;
    }

    public void setOxAuthPersistentJwt(String[] oxAuthPersistentJwt) {
        this.oxAuthPersistentJwt = oxAuthPersistentJwt;
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getAttribute(String ldapAttribute) {
        String attribute = null;
        if (ldapAttribute != null && !ldapAttribute.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!customAttribute.getName().equals(ldapAttribute)) continue;
                attribute = customAttribute.getValue();
                break;
            }
        }
        return attribute;
    }

    public List<String> getAttributeValues(String ldapAttribute) {
        List<String> values = null;
        if (ldapAttribute != null && !ldapAttribute.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!customAttribute.getName().equals(ldapAttribute)) continue;
                values = customAttribute.getValues();
                break;
            }
        }
        return values;
    }

    public Object getAttribute(String userAttribute, boolean optional) throws InvalidClaimException {
        String attribute = null;
        for (CustomAttribute customAttribute : this.customAttributes) {
            if (!customAttribute.getName().equals(userAttribute)) continue;
            List<String> values = customAttribute.getValues();
            if (values == null) break;
            if (values.size() == 1) {
                attribute = values.get(0);
                break;
            }
            JSONArray array = new JSONArray();
            for (String v : values) {
                array.put((Object)v);
            }
            attribute = array;
            break;
        }
        if (attribute != null) {
            return attribute;
        }
        if (optional) {
            return attribute;
        }
        throw new InvalidClaimException("The claim " + userAttribute + " was not found.");
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }
}

