/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.io.Serializable;
import java.util.Date;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapJsonObject;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.xdi.oxauth.model.common.SessionIdAccessMap;
import org.xdi.oxauth.model.common.SessionIdAttribute;

@Name(value="sessionUser")
@AutoCreate
@LdapEntry
@LdapObjectClass(values={"top", "oxAuthSessionId"})
public class SessionId
implements Serializable {
    @LdapDN
    private String dn;
    @LdapAttribute(name="uniqueIdentifier")
    private String id;
    @LdapAttribute(name="lastModifiedTime")
    private Date lastUsedAt;
    @LdapAttribute(name="oxAuthUserDN")
    private String userDn;
    @LdapAttribute(name="oxAuthAuthenticationTime")
    private Date authenticationTime;
    @LdapAttribute(name="oxAuthPermissionGranted")
    private Boolean permissionGranted;
    @LdapJsonObject
    @LdapAttribute(name="oxAuthPermissionGrantedMap")
    private SessionIdAccessMap permissionGrantedMap;
    @LdapJsonObject
    @LdapAttribute(name="oxAuthSessionAttribute")
    private SessionIdAttribute[] sessionIdAttributes;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String p_id) {
        this.id = p_id;
    }

    public Date getLastUsedAt() {
        return this.lastUsedAt != null ? new Date(this.lastUsedAt.getTime()) : null;
    }

    public void setLastUsedAt(Date p_lastUsedAt) {
        this.lastUsedAt = p_lastUsedAt != null ? new Date(p_lastUsedAt.getTime()) : null;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String p_userDn) {
        this.userDn = p_userDn;
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime != null ? new Date(this.authenticationTime.getTime()) : null;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime != null ? new Date(authenticationTime.getTime()) : null;
    }

    public Boolean getPermissionGranted() {
        return this.permissionGranted;
    }

    public void setPermissionGranted(Boolean permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    public SessionIdAccessMap getPermissionGrantedMap() {
        return this.permissionGrantedMap;
    }

    public void setPermissionGrantedMap(SessionIdAccessMap permissionGrantedMap) {
        this.permissionGrantedMap = permissionGrantedMap;
    }

    public Boolean isPermissionGrantedForClient(String clientId) {
        if (this.permissionGrantedMap != null) {
            return this.permissionGrantedMap.get(clientId);
        }
        return false;
    }

    public void addPermission(String clientId, Boolean granted) {
        if (this.permissionGrantedMap == null) {
            this.permissionGrantedMap = new SessionIdAccessMap();
        }
        this.permissionGrantedMap.put(clientId, granted);
    }

    public SessionIdAttribute[] getSessionIdAttributes() {
        return this.sessionIdAttributes;
    }

    public void setSessionIdAttributes(SessionIdAttribute[] sessionIdAttributes) {
        this.sessionIdAttributes = sessionIdAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionId id1 = (SessionId)o;
        return !(this.id != null ? !this.id.equals(id1.id) : id1.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SessionId [dn=").append(this.dn).append(", id=").append(this.id).append(", lastUsedAt=").append(this.lastUsedAt).append(", userDn=").append(this.userDn).append(", authenticationTime=").append(this.authenticationTime).append(", permissionGranted=").append(this.permissionGranted).append("]");
        return builder.toString();
    }
}

