/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.introspection.ws.rs;

import com.wordnik.swagger.annotations.Api;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.IntrospectionResponse;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.util.ServerUtil;

@Name(value="introspectionWS")
@Path(value="/introspection")
@Api(value="/introspection", description="The Introspection Endpoint is an OAuth 2 Endpoint that responds to    HTTP GET and HTTP POST requests from token holders.  The endpoint    takes a single parameter representing the token (and optionally    further authentication) and returns a JSON document representing the meta information surrounding the token.")
public class IntrospectionWebService {
    @Logger
    private Log log;
    @In
    private TokenService tokenService;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private AuthorizationGrantList authorizationGrantList;

    @GET
    @Produces(value={"application/json"})
    public Response introspectGet(@HeaderParam(value="Authorization") String p_authorization, @QueryParam(value="token") String p_token) {
        return this.introspect(p_authorization, p_token);
    }

    @POST
    @Produces(value={"application/json"})
    public Response introspectPost(@HeaderParam(value="Authorization") String p_authorization, @FormParam(value="token") String p_token) {
        return this.introspect(p_authorization, p_token);
    }

    private Response introspect(String p_authorization, String p_token) {
        try {
            this.log.trace((Object)"Introspect token, authorization: {}, token to introsppect: {}", new Object[]{p_authorization, p_token});
            if (StringUtils.isNotBlank((String)p_authorization) && StringUtils.isNotBlank((String)p_token)) {
                AbstractToken accessToken;
                AuthorizationGrant authorizationGrant = this.tokenService.getAuthorizationGrant(p_authorization);
                if (authorizationGrant != null && (accessToken = authorizationGrant.getAccessToken(this.tokenService.getTokenFromAuthorizationParameter(p_authorization))) != null && accessToken.isValid()) {
                    AbstractToken tokenToIntrospect;
                    IntrospectionResponse response = new IntrospectionResponse(false);
                    AuthorizationGrant grantOfIntrospectionToken = this.authorizationGrantList.getAuthorizationGrantByAccessToken(p_token);
                    if (grantOfIntrospectionToken != null && (tokenToIntrospect = grantOfIntrospectionToken.getAccessToken(p_token)) != null) {
                        response.setActive(tokenToIntrospect.isValid());
                        response.setExpiresAt(tokenToIntrospect.getExpirationDate());
                        response.setIssuedAt(tokenToIntrospect.getCreationDate());
                        response.setAuthLevel(tokenToIntrospect.getAuthLevel());
                        response.setAuthMode(tokenToIntrospect.getAuthMode());
                    }
                    return Response.status((Response.Status)Response.Status.OK).entity((Object)ServerUtil.asJson(response)).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED)).build();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST)).build();
    }
}

