/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.idgen.ws.rs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.python.core.PyObject;
import org.xdi.oxauth.idgen.ws.rs.IdGenerator;
import org.xdi.oxauth.idgen.ws.rs.InumGenerator;
import org.xdi.oxauth.model.common.IdType;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.service.PythonService;

@Scope(value=ScopeType.STATELESS)
@Name(value="idGenService")
@AutoCreate
public class IdGenService
implements IdGenerator {
    public static final String PYTHON_CLASS_NAME = "PythonExternalIdGenerator";
    @Logger
    private Log log;
    @In
    private PythonService pythonService;
    @In
    private InumGenerator inumGenerator;

    public static IdGenService instance() {
        return (IdGenService)ServerUtil.instance(IdGenService.class);
    }

    public String generateId(IdType p_idType, String p_idPrefix) {
        return this.generateId(p_idType.getType(), p_idPrefix);
    }

    @Override
    public String generateId(String p_idType, String p_idPrefix) {
        String idGenerationScript = ConfigurationFactory.getIdGenerationScript();
        IdGenerator pythonGenerator = this.createPythonGenerator(idGenerationScript);
        return pythonGenerator.generateId(p_idType, p_idPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdGenerator createPythonGenerator(String p_pythonScript) {
        block8: {
            IdGenerator idGenerator;
            if (!StringUtils.isNotBlank((String)p_pythonScript)) break block8;
            ByteArrayInputStream bis = null;
            try {
                bis = new ByteArrayInputStream(p_pythonScript.getBytes("UTF-8"));
                IdGenerator result = (IdGenerator)this.pythonService.loadPythonScript((InputStream)bis, PYTHON_CLASS_NAME, IdGenerator.class, new PyObject[0]);
                if (result == null) {
                    this.log.error((Object)"Python ID Generator script does not implement IdGenerator interface or script is corrupted.", new Object[0]);
                }
                idGenerator = result;
            }
            catch (Exception e) {
                try {
                    try {
                        this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(bis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)bis);
                }
                catch (Exception ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
                }
            }
            IOUtils.closeQuietly((InputStream)bis);
            return idGenerator;
        }
        this.log.error((Object)"Failed to prepare python external ID Generator", new Object[0]);
        this.log.info((Object)"Using fallback INumGenerator class.", new Object[0]);
        return this.inumGenerator;
    }
}

