/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.idgen.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.idgen.ws.rs.IdGenService;
import org.xdi.oxauth.model.common.Id;
import org.xdi.oxauth.model.common.IdType;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.service.uma.RPTManager;
import org.xdi.oxauth.service.uma.resourceserver.PermissionService;
import org.xdi.oxauth.service.uma.resourceserver.RsResourceType;
import org.xdi.oxauth.service.uma.resourceserver.RsScopeType;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.Pair;

@Name(value="idGenWS")
@Path(value="/id")
@Api(value="/id", description="ID Generation")
public class IdGenRestWebService {
    @Logger
    private Log log;
    @In
    private IdGenService idGenService;
    @In
    private TokenService tokenService;
    @In
    private PermissionService umaRsPermissionService;
    @In
    private RPTManager rptManager;

    @GET
    @Path(value="/{prefix}/{type}/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Generates ID for given prefix and type.", notes="Generates ID for given prefix and type. ", response=Response.class, responseContainer="String")
    public Response generateJsonInum(@PathParam(value="prefix") @ApiParam(value="Prefix for id. E.g. if prefix is @!1111 and server will generate id: !0000 then ID returned by service would be: @!1111!0000", required=true) String prefix, @PathParam(value="type") @ApiParam(value="Type of id", required=true, allowableValues="PEOPLE, ORGANIZATION, APPLIANCE, GROUP, SERVER, ATTRIBUTE, TRUST_RELATIONSHIP, CLIENTS") String type, @HeaderParam(value="Authorization") String p_authorization) {
        return this.generateId(prefix, type, p_authorization, "application/json");
    }

    @GET
    @Path(value="/{prefix}/{type}/")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Generates ID for given prefix and type.", notes="Generates ID for given prefix and type. ", response=Response.class, responseContainer="String")
    public Response generateTextInum(@PathParam(value="prefix") String prefix, @PathParam(value="type") String type, @HeaderParam(value="Authorization") String p_authorization) {
        return this.generateId(prefix, type, p_authorization, "text/plain");
    }

    @GET
    @Path(value="/{prefix}/{type}/")
    @Produces(value={"text/xml"})
    @ApiOperation(value="Generates ID for given prefix and type.", notes="Generates ID for given prefix and type. ", response=Response.class, responseContainer="String")
    public Response generateXmlInum(@PathParam(value="prefix") @ApiParam(value="Prefix for id. E.g. if prefix is @!1111 and server will generate id: !0000 then ID returned by service would be: @!1111!0000", required=true) String prefix, @PathParam(value="type") @ApiParam(value="Type of id", required=true, allowableValues="PEOPLE, ORGANIZATION, APPLIANCE, GROUP, SERVER, ATTRIBUTE, TRUST_RELATIONSHIP, CLIENTS") String type, @HeaderParam(value="Authorization") String p_authorization) {
        return this.generateId(prefix, type, p_authorization, "text/xml");
    }

    @GET
    @Path(value="/{prefix}/{type}/")
    @Produces(value={"text/html"})
    @ApiOperation(value="Generates ID for given prefix and type.", notes="Generates ID for given prefix and type. ", response=Response.class, responseContainer="String")
    public Response generateHtmlInum(@PathParam(value="prefix") @ApiParam(value="Prefix for id. E.g. if prefix is @!1111 and server will generate id: !0000 then ID returned by service would be: @!1111!0000", required=true) String prefix, @PathParam(value="type") @ApiParam(value="Type of id", required=true, allowableValues="PEOPLE, ORGANIZATION, APPLIANCE, GROUP, SERVER, ATTRIBUTE, TRUST_RELATIONSHIP, CLIENTS") String type, @HeaderParam(value="Authorization") String p_authorization) {
        return this.generateId(prefix, type, p_authorization, "text/html");
    }

    private Pair<Boolean, Response> hasEnoughPermissions(String p_authorization, List<RsScopeType> p_scopes) {
        UmaRPT rpt;
        String rptString = this.tokenService.getTokenFromAuthorizationParameter(p_authorization);
        if (StringUtils.isNotBlank((String)rptString) && (rpt = this.rptManager.getRPTByCode(rptString)) != null) {
            rpt.checkExpired();
            if (rpt.isValid()) {
                List<ResourceSetPermission> rptPermissions = this.rptManager.getRptPermissions(rpt);
                return this.umaRsPermissionService.hasEnoughPermissionsWithTicketRegistration(rpt, rptPermissions, RsResourceType.ID_GENERATION, p_scopes);
            }
        }
        this.log.debug((Object)"Client does not present RPT. Return HTTP 401 (Unauthorized)\n with reference to AM as_uri: {0}", new Object[]{ConfigurationFactory.getConfiguration().getUmaConfigurationEndpoint()});
        return new Pair((Object)false, (Object)UnauthorizedResponseHolder.UNAUTHORIZED_RESPONSE);
    }

    private Response generateId(String prefix, String type, String p_authorization, String p_mediaType) {
        try {
            Pair<Boolean, Response> pair = this.hasEnoughPermissions(p_authorization, Arrays.asList(RsScopeType.GENERATE_ID));
            if (((Boolean)pair.getFirst()).booleanValue()) {
                String entity = this.generateIdEntity(prefix, type, p_mediaType);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).build();
            }
            this.log.debug((Object)"RPT doesn't have enough permissions, access FORBIDDEN. Returns HTTP 403 (Forbidden).", new Object[0]);
            return (Response)pair.getSecond();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private String generateIdEntity(String prefix, String type, String p_mediaType) throws IOException {
        String id = this.generateId(prefix, type);
        if (p_mediaType.equals("application/json")) {
            return ServerUtil.asJson(new Id(id));
        }
        if (p_mediaType.equals("text/plain")) {
            return id;
        }
        if (p_mediaType.equals("text/html")) {
            return "<html><title>" + IdType.fromString((String)type).getHtmlText() + "</title><body><h1>" + type + ": " + id + "</h1></body></html> ";
        }
        if (p_mediaType.equals("text/xml")) {
            return "<?xml version=\"1.0\"?><inum type='" + IdType.fromString((String)type).getValue() + "'>" + id + "</inum>";
        }
        return "";
    }

    private String generateId(String prefix, String type) {
        String id = this.idGenService.generateId(type, prefix);
        this.log.trace((Object)"Generated id: {0}, prefix: {1}, type: {2}", new Object[]{id, prefix, type});
        return id;
    }

    private static class UnauthorizedResponseHolder {
        public static Response UNAUTHORIZED_RESPONSE = UnauthorizedResponseHolder.unauthorizedResponse();

        private UnauthorizedResponseHolder() {
        }

        public static Response unauthorizedResponse() {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("host_id", (Object)ConfigurationFactory.getConfiguration().getIssuer()).header("as_uri", (Object)ConfigurationFactory.getConfiguration().getUmaConfigurationEndpoint()).build();
        }
    }
}

