/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.federation.ws.rs;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.federation.ws.rs.FederationDataWS;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.federation.FederationErrorResponseType;
import org.xdi.oxauth.model.federation.FederationRequest;
import org.xdi.oxauth.service.FederationDataService;
import org.xdi.oxauth.service.FederationMetadataService;

@Name(value="federationDataWS")
public class FederationDataWSImpl
implements FederationDataWS {
    @Logger
    private Log log;
    @In
    private FederationDataService federationDataService;
    @In
    private FederationMetadataService federationMetadataService;
    @In
    private ErrorResponseFactory errorResponseFactory;

    @Override
    public Response requestJoin(String federationId, String entityType, String displayName, String opId, String domain, String redirectUri, String x509url, String x509pem, HttpServletRequest request, SecurityContext sec) {
        block14: {
            try {
                this.log.trace((Object)"Federation join request - federationId: {0}, entityType: {1}, displayName: {2}, opId: {3}, domain: {4}, redirectUri: {5}, x509url: {6}, x509pem {7}", new Object[]{federationId, entityType, displayName, opId, domain, redirectUri, x509url, x509pem});
                this.federationMetadataService.getMetadata(federationId, false);
                FederationRequest.Type type = FederationRequest.Type.fromValue((String)entityType);
                if (type != null) {
                    if (StringUtils.isBlank((String)displayName)) {
                        return this.errorResponse(FederationErrorResponseType.INVALID_DISPLAY_NAME);
                    }
                    FederationRequest federationRequest = new FederationRequest();
                    federationRequest.setFederationId(federationId);
                    federationRequest.setEntityType(entityType);
                    federationRequest.setDisplayName(displayName);
                    switch (type) {
                        case OP: {
                            if (StringUtils.isBlank((String)domain)) {
                                return this.errorResponse(FederationErrorResponseType.INVALID_DOMAIN);
                            }
                            if (StringUtils.isBlank((String)opId)) {
                                return this.errorResponse(FederationErrorResponseType.INVALID_OP_ID);
                            }
                            federationRequest.setDomain(domain);
                            federationRequest.setOpId(opId);
                            break;
                        }
                        case RP: {
                            if (StringUtils.isBlank((String)redirectUri)) {
                                return this.errorResponse(FederationErrorResponseType.INVALID_REDIRECT_URI);
                            }
                            String[] splitedRedirectUris = redirectUri.split(" ");
                            if (splitedRedirectUris != null && splitedRedirectUris.length > 0) {
                                federationRequest.setRedirectUri(Arrays.asList(splitedRedirectUris));
                                break;
                            }
                            return this.errorResponse(FederationErrorResponseType.INVALID_REDIRECT_URI);
                        }
                        default: {
                            return this.errorResponse(FederationErrorResponseType.INVALID_ENTITY_TYPE);
                        }
                    }
                    if (this.federationDataService.persist(federationRequest)) {
                        return Response.status((Response.Status)Response.Status.OK).build();
                    }
                    break block14;
                }
                return this.errorResponse(FederationErrorResponseType.INVALID_ENTITY_TYPE);
            }
            catch (FederationMetadataService.InvalidIdException e) {
                this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return this.errorResponse(FederationErrorResponseType.INVALID_FEDERATION_ID);
            }
            catch (Exception e) {
                this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        return this.errorResponse(FederationErrorResponseType.INVALID_REQUEST);
    }

    private Response errorResponse(FederationErrorResponseType p_type) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)p_type).toJSonString()).build();
    }
}

