/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.authorize.ws.rs;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.international.LocaleSelector;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.xdi.model.AuthenticationScriptUsageType;
import org.xdi.model.config.CustomAuthenticationConfiguration;
import org.xdi.oxauth.auth.Authenticator;
import org.xdi.oxauth.model.ExternalAuthenticatorConfiguration;
import org.xdi.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.xdi.oxauth.model.authorize.AuthorizeParamsValidator;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.federation.FederationTrust;
import org.xdi.oxauth.model.federation.FederationTrustStatus;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.util.LocaleUtil;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.AuthenticationService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.ExternalAuthenticationService;
import org.xdi.oxauth.service.FederationDataService;
import org.xdi.oxauth.service.RedirectionUriService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.oxauth.service.SessionIdService;
import org.xdi.oxauth.service.UserGroupService;
import org.xdi.oxauth.service.UserService;
import org.xdi.util.StringHelper;

@Name(value="authorizeAction")
@org.jboss.seam.annotations.Scope(value=ScopeType.EVENT)
public class AuthorizeAction {
    public static final List<String> ALLOWED_PARAMETER = Collections.unmodifiableList(Arrays.asList("scope", "response_type", "client_id", "redirect_uri", "state", "nonce", "display", "prompt", "max_age", "ui_locales", "id_token_hint", "login_hint", "acr_values", "amr_values", "session_id", "request", "request_uri"));
    @Logger
    private Log log;
    @In
    private ClientService clientService;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private UserGroupService userGroupService;
    @In
    private FederationDataService federationDataService;
    @In
    private SessionIdService sessionIdService;
    @In
    private UserService userService;
    @In
    private RedirectionUriService redirectionUriService;
    @In
    private AuthenticationService authenticationService;
    @In
    private ExternalAuthenticationService externalAuthenticationService;
    @In
    private SessionId sessionUser;
    @In(value="org.jboss.seam.international.localeSelector")
    private LocaleSelector localeSelector;
    @RequestParameter(value="auth_level")
    private String authLevel;
    @RequestParameter(value="auth_mode")
    private String authMode;
    @In
    private Identity identity;
    private String scope;
    private String responseType;
    private String clientId;
    private String redirectUri;
    private String state;
    private String nonce;
    private String display;
    private String prompt;
    private Integer maxAge;
    private String uiLocales;
    private String idTokenHint;
    private String loginHint;
    private String acrValues;
    private String amrValues;
    private String request;
    private String requestUri;
    private String sessionId;

    public void checkUiLocales() {
        List uiLocalesList = null;
        if (StringUtils.isNotBlank((String)this.uiLocales)) {
            uiLocalesList = Util.splittedStringAsList((String)this.uiLocales, (String)" ");
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ArrayList supportedLocales = new ArrayList();
            Iterator it = facesContext.getApplication().getSupportedLocales();
            while (it.hasNext()) {
                supportedLocales.add(it.next());
            }
            Locale matchingLocale = LocaleUtil.localeMatch((List)uiLocalesList, supportedLocales);
            if (matchingLocale != null) {
                this.localeSelector.setLocale(matchingLocale);
            }
        }
    }

    private SessionId getSession() {
        SessionId ldapSessionId;
        this.initSessionId();
        if (!this.identity.isLoggedIn()) {
            Authenticator authenticator = (Authenticator)Component.getInstance(Authenticator.class, (boolean)true);
            authenticator.authenticateBySessionId(this.sessionId);
        }
        if ((ldapSessionId = this.sessionIdService.getSessionId(this.sessionId)) == null) {
            this.identity.logout();
        }
        return ldapSessionId;
    }

    public void checkPermissionGranted() {
        Client client;
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        SessionId session = this.getSession();
        this.authenticationService.storeRequestHeadersInSession((HttpServletRequest)externalContext.getRequest());
        if (session == null || session.getUserDn() == null) {
            HashMap<String, String> parameterMap = externalContext.getRequestParameterMap();
            String redirectTo = "/login.xhtml";
            boolean useExternalAuthenticator = this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.INTERACTIVE);
            if (useExternalAuthenticator) {
                List amrValuesList = null;
                try {
                    amrValuesList = Util.jsonArrayStringAsList((String)this.amrValues);
                }
                catch (JSONException ex) {
                    this.invalidRequest();
                    return;
                }
                ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration = amrValuesList != null && !amrValuesList.isEmpty() ? this.externalAuthenticationService.determineExternalAuthenticatorConfiguration(AuthenticationScriptUsageType.INTERACTIVE, amrValuesList) : this.externalAuthenticationService.determineExternalAuthenticatorConfiguration(AuthenticationScriptUsageType.INTERACTIVE, 1, this.authLevel, this.authMode);
                if (externalAuthenticatorConfiguration == null) {
                    this.log.error((Object)"Failed to get ExternalAuthenticatorConfiguration. auth_step: {0}, auth_mode: {1}, auth_level: {2}", new Object[]{1, this.authMode, this.authLevel});
                    this.permissionDenied();
                    return;
                }
                this.authMode = externalAuthenticatorConfiguration.getName();
                parameterMap = new HashMap<String, String>(parameterMap);
                parameterMap.remove("auth_level");
                parameterMap.put("auth_mode", this.authMode);
                parameterMap.put("auth_step", Integer.toString(1));
                String tmpRedirectTo = this.externalAuthenticationService.executeExternalAuthenticatorGetPageForStep(externalAuthenticatorConfiguration, 1);
                if (StringHelper.isNotEmpty((String)tmpRedirectTo)) {
                    this.log.trace((Object)"Redirect to custom authentication login page: {0}", new Object[]{tmpRedirectTo});
                    redirectTo = tmpRedirectTo;
                }
            }
            FacesManager.instance().redirect(redirectTo, (Map)parameterMap, false);
            return;
        }
        if (this.clientId != null && !this.clientId.isEmpty() && (client = this.clientService.getClient(this.clientId)) != null) {
            List prompts;
            if (StringUtils.isBlank((String)this.redirectionUriService.validateRedirectionUri(this.clientId, this.redirectUri))) {
                this.permissionDenied();
            }
            User user = this.userService.getUserByDn(session.getUserDn());
            this.log.trace((Object)("checkPermissionGranted, user = " + user), new Object[0]);
            if (user != null && client.hasUserGroups() && !this.userGroupService.isInAnyGroup(client.getUserGroups(), user.getDn())) {
                this.permissionDenied();
            }
            if (ConfigurationFactory.getConfiguration().getFederationEnabled().booleanValue()) {
                List<FederationTrust> list = this.federationDataService.getTrustByClient(client, FederationTrustStatus.ACTIVE);
                if (list == null || list.isEmpty()) {
                    this.log.trace((Object)"Deny authorization, client is not in any federation trust, client: {0}", new Object[]{client.getDn()});
                    this.permissionDenied();
                } else if (FederationDataService.skipAuthorization(list)) {
                    this.log.trace((Object)"Skip authorization (permissions granted), client is in federation trust where skip is allowed, client: {1}", new Object[]{client.getDn()});
                    this.permissionGranted();
                }
            }
            if (AuthorizeParamsValidator.validatePrompt(prompts = Prompt.fromString((String)this.prompt, (String)" "))) {
                if (ConfigurationFactory.getConfiguration().getTrustedClientEnabled().booleanValue()) {
                    if (Boolean.parseBoolean(client.getTrustedClient()) && !prompts.contains(Prompt.CONSENT)) {
                        this.permissionGranted();
                    }
                } else {
                    this.consentRequired();
                }
            } else {
                this.invalidRequest();
            }
        }
    }

    private void initSessionId() {
        if (StringUtils.isBlank((String)this.sessionId)) {
            try {
                Object request = FacesContext.getCurrentInstance().getExternalContext().getRequest();
                this.sessionId = SessionIdService.instance().getSessionIdFromCookie((HttpServletRequest)request);
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
    }

    @Observer(value={"org.xdi.oxauth.security.loginSuccessful"})
    public void onSuccessfulLogin(String authMode, Map<String, String> requestParameterMap) {
        this.onSuccessfulLoginImpl(authMode, requestParameterMap);
    }

    @Observer(value={"org.jboss.seam.security.loginSuccessful"})
    public void onSuccessfulLogin() {
        this.onSuccessfulLoginImpl(null, null);
    }

    public void onSuccessfulLoginImpl(String authMode, Map<String, String> requestParameterMap) {
        User user;
        this.log.info((Object)"Attempting to redirect user. SessionUser: {0}", new Object[]{this.sessionUser});
        User user2 = user = this.sessionUser != null && StringUtils.isNotBlank((String)this.sessionUser.getUserDn()) ? this.userService.getUserByDn(this.sessionUser.getUserDn()) : null;
        if (this.sessionUser != null) {
            this.sessionUser.setAuthenticationTime(new Date());
        }
        this.sessionIdService.updateSessionWithLastUsedDate(this.sessionUser, Prompt.fromString((String)this.prompt, (String)" "));
        this.log.info((Object)"Attempting to redirect user. User: {0}", new Object[]{user});
        if (user != null) {
            Map<String, Object> map = requestParameterMap == null ? this.parametersForRedirect(user) : this.parametersForRedirect(user, requestParameterMap);
            this.addAuthModeParameters(map, authMode);
            this.log.trace((Object)"Logged in successfully! User: {0}, page: /authorize.xhtml, map: {1}", new Object[]{user, map});
            FacesManager.instance().redirect("/authorize.xhtml", map, false);
        }
    }

    private Map<String, Object> parametersForRedirect(User p_user) {
        Map parameterMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        return this.parametersForRedirect(p_user, parameterMap);
    }

    private Map<String, Object> parametersForRedirect(User p_user, Map<String, String> requestParameterMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (requestParameterMap != null && !requestParameterMap.isEmpty()) {
            Set<Map.Entry<String, String>> set = requestParameterMap.entrySet();
            for (Map.Entry<String, String> entry : set) {
                if (!ALLOWED_PARAMETER.contains(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        if (!result.isEmpty()) {
            if (this.sessionUser == null || this.sessionUser.getId() == null) {
                this.sessionUser = this.sessionIdService.generateSessionIdInteractive(p_user.getDn());
            }
            result.put("session_id", this.sessionUser.getId());
        }
        return result;
    }

    public void addAuthModeParameters(Map<String, Object> parameterMap, String authMode) {
        ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration;
        if (StringHelper.isNotEmpty((String)authMode) && (externalAuthenticatorConfiguration = this.externalAuthenticationService.getExternalAuthenticatorConfiguration(AuthenticationScriptUsageType.INTERACTIVE, authMode)) != null) {
            CustomAuthenticationConfiguration customAuthenticationConfiguration = externalAuthenticatorConfiguration.getCustomAuthenticationConfiguration();
            parameterMap.put("auth_mode", customAuthenticationConfiguration.getName());
            parameterMap.put("auth_level", customAuthenticationConfiguration.getLevel());
        }
    }

    public List<Scope> getScopes() {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        ScopeService scopeService = ScopeService.instance();
        if (this.scope != null && !this.scope.isEmpty()) {
            String[] scopesName;
            for (String scopeName : scopesName = this.scope.split(" ")) {
                Scope s = scopeService.getScopeByDisplayName(scopeName);
                if (s == null || s.getDescription() == null) continue;
                scopes.add(s);
            }
        }
        return scopes;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public String getUiLocales() {
        return this.uiLocales;
    }

    public void setUiLocales(String uiLocales) {
        this.uiLocales = uiLocales;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public String getAmrValues() {
        return this.amrValues;
    }

    public void setAmrValues(String amrValues) {
        this.amrValues = amrValues;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String p_sessionId) {
        this.sessionId = p_sessionId;
    }

    public void permissionGranted() {
        try {
            SessionId session = this.getSession();
            session.addPermission(this.clientId, true);
            this.sessionIdService.updateSessionWithLastUsedDate(session, Prompt.fromString((String)this.prompt, (String)" "));
            SessionIdService.instance().createSessionIdCookie(this.sessionId);
            String parametersAsString = this.authenticationService.parametersAsString();
            String uri = "seam/resource/restv1/oxauth/authorize?" + parametersAsString;
            this.log.trace((Object)"permissionGranted, redirectTo: {0}", new Object[]{uri});
            FacesManager.instance().redirectToExternalURL(uri);
        }
        catch (UnsupportedEncodingException e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void permissionDenied() {
        this.log.trace((Object)"permissionDenied", new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(this.redirectUri);
        if (this.redirectUri != null && this.redirectUri.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, this.getState()));
        FacesManager.instance().redirectToExternalURL(sb.toString());
    }

    public void invalidRequest() {
        this.log.trace((Object)"invalidRequest", new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(this.redirectUri);
        if (this.redirectUri != null && this.redirectUri.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, this.getState()));
        FacesManager.instance().redirectToExternalURL(sb.toString());
    }

    public void consentRequired() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.redirectUri);
        if (this.redirectUri != null && this.redirectUri.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.CONSENT_REQUIRED, this.getState()));
        FacesManager.instance().redirectToExternalURL(sb.toString());
    }
}

