/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.log.Log;
import org.jboss.seam.resteasy.Application;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.SimplePrincipal;
import org.xdi.model.AuthenticationScriptUsageType;
import org.xdi.oxauth.model.ExternalAuthenticatorConfiguration;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.session.OAuthCredentials;
import org.xdi.oxauth.model.session.SessionClient;
import org.xdi.oxauth.service.AuthenticationService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.ExternalAuthenticationService;
import org.xdi.oxauth.service.SessionIdService;
import org.xdi.oxauth.service.UserService;
import org.xdi.util.StringHelper;

@Name(value="authenticator")
@Scope(value=ScopeType.EVENT)
public class Authenticator
implements Serializable {
    private static final long serialVersionUID = 669395320060928092L;
    @Logger
    private Log log;
    @In
    private Identity identity;
    @In
    private OAuthCredentials credentials;
    @In
    private UserService userService;
    @In
    private ClientService clientService;
    @In
    private SessionIdService sessionIdService;
    @In
    private AuthenticationService authenticationService;
    @In
    private ExternalAuthenticationService externalAuthenticationService;
    @In
    private FacesMessages facesMessages;
    @RequestParameter(value="auth_step")
    private Integer authStep;
    @RequestParameter(value="auth_level")
    private String authLevel;
    @RequestParameter(value="auth_mode")
    private String authMode;
    @RequestParameter(value="amr")
    private String authAmr;

    public boolean authenticate() {
        return this.authenticateImpl(Contexts.getEventContext(), true);
    }

    public String authenticateWithOutcome() {
        boolean result = this.authenticateImpl(Contexts.getEventContext(), true);
        if (result) {
            return "success";
        }
        return "failure";
    }

    public boolean authenticateWebService() {
        return this.authenticateImpl(this.getWebServiceContext(), false);
    }

    public Context getWebServiceContext() {
        return Contexts.getEventContext();
    }

    public boolean authenticateImpl(Context context, boolean interactive) {
        Map<String, String> restoredRequestParametersFromSession = this.authenticationService.restoreRequestParametersFromSession();
        this.initCustomAuthenticatorVariables(restoredRequestParametersFromSession);
        this.setAuthModeFromAmr();
        if (interactive && this.authStep == null) {
            return this.authenticationFailed();
        }
        try {
            if (StringHelper.isNotEmpty((String)this.credentials.getUsername()) && StringHelper.isNotEmpty((String)this.credentials.getPassword()) && this.credentials.getUsername().startsWith("@!")) {
                boolean loggedIn;
                boolean isServiceUsesExternalAuthenticator;
                boolean bl = isServiceUsesExternalAuthenticator = !interactive && this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.SERVICE);
                if (isServiceUsesExternalAuthenticator) {
                    ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration = this.externalAuthenticationService.determineExternalAuthenticatorConfiguration(AuthenticationScriptUsageType.SERVICE, 1, this.authLevel, this.authMode);
                    if (externalAuthenticatorConfiguration == null) {
                        this.log.error((Object)"Failed to get ExternalAuthenticatorConfiguration. auth_step: {0}, auth_mode: {1}, auth_level: {2}", new Object[]{this.authStep, this.authMode, this.authLevel});
                    } else {
                        this.authMode = externalAuthenticatorConfiguration.getName();
                        boolean result = this.externalAuthenticationService.executeExternalAuthenticatorAuthenticate(externalAuthenticatorConfiguration, null, 1);
                        this.log.info((Object)"Authentication result for {0}. auth_step: {1}, result: {2}", new Object[]{this.credentials.getUsername(), this.authStep, result});
                        if (result) {
                            this.configureSessionClient(context);
                            this.log.info((Object)"Authentication success for Client: {0}", new Object[]{this.credentials.getUsername()});
                            return true;
                        }
                    }
                }
                if (loggedIn = this.clientService.authenticate(this.credentials.getUsername(), this.credentials.getPassword())) {
                    this.configureSessionClient(context);
                    this.log.info((Object)"Authentication success for Client: {0}", new Object[]{this.credentials.getUsername()});
                    return true;
                }
            } else if (interactive) {
                boolean authenticated;
                if (this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.INTERACTIVE)) {
                    ExternalContext extCtx = FacesContext.getCurrentInstance().getExternalContext();
                    ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration = this.externalAuthenticationService.determineExternalAuthenticatorConfiguration(AuthenticationScriptUsageType.INTERACTIVE, 1, this.authLevel, this.authMode);
                    if (externalAuthenticatorConfiguration == null) {
                        this.log.error((Object)"Failed to get ExternalAuthenticatorConfiguration. auth_step: {0}, auth_mode: {1}, auth_level: {2}", new Object[]{this.authStep, this.authMode, this.authLevel});
                        return this.authenticationFailed();
                    }
                    this.authMode = externalAuthenticatorConfiguration.getName();
                    boolean result = this.externalAuthenticationService.executeExternalAuthenticatorAuthenticate(externalAuthenticatorConfiguration, extCtx.getRequestParameterValuesMap(), this.authStep);
                    this.log.info((Object)"Authentication result for {0}. auth_step: {1}, result: {2}", new Object[]{this.credentials.getUsername(), this.authStep, result});
                    if (!result) {
                        return this.authenticationFailed();
                    }
                    int countAuthenticationSteps = this.externalAuthenticationService.executeExternalAuthenticatorGetCountAuthenticationSteps(externalAuthenticatorConfiguration);
                    if (this.authStep < countAuthenticationSteps) {
                        int nextStep = this.authStep + 1;
                        String redirectTo = this.externalAuthenticationService.executeExternalAuthenticatorGetPageForStep(externalAuthenticatorConfiguration, nextStep);
                        if (StringHelper.isEmpty((String)redirectTo)) {
                            return this.authenticationFailed();
                        }
                        Contexts.getEventContext().set("auth_step", (Object)Integer.toString(nextStep));
                        Contexts.getEventContext().set("auth_mode", (Object)this.authMode);
                        List<String> extraParameters = this.externalAuthenticationService.executeExternalAuthenticatorGetExtraParametersForStep(externalAuthenticatorConfiguration, nextStep);
                        Map<String, String> parametersMap = restoredRequestParametersFromSession == null ? this.authenticationService.getParametersMap(extraParameters) : this.authenticationService.getParametersMap(extraParameters, restoredRequestParametersFromSession);
                        this.log.trace((Object)"Redirect to page: {0}", new Object[]{redirectTo});
                        FacesManager.instance().redirect(redirectTo, parametersMap, false);
                        return false;
                    }
                    if (this.authStep == countAuthenticationSteps) {
                        this.authenticationService.configureEventUser(interactive);
                        SimplePrincipal principal = new SimplePrincipal(this.credentials.getUsername());
                        this.identity.acceptExternallyAuthenticatedPrincipal((Principal)principal);
                        this.identity.quietLogin();
                        if (Events.exists()) {
                            this.log.info((Object)"Sending event to trigger user redirection: {0}", new Object[]{this.credentials.getUsername()});
                            Events.instance().raiseEvent("org.xdi.oxauth.security.loginSuccessful", new Object[]{this.authMode, restoredRequestParametersFromSession});
                        }
                        this.log.info((Object)"Authentication success for User: {0}", new Object[]{this.credentials.getUsername()});
                        return true;
                    }
                } else if (StringHelper.isNotEmpty((String)this.credentials.getUsername()) && (authenticated = this.authenticationService.authenticate(this.credentials.getUsername(), this.credentials.getPassword()))) {
                    this.authenticationService.configureEventUser(interactive);
                    if (Events.exists()) {
                        this.log.info((Object)"Sending event to trigger user redirection: {0}", new Object[]{this.credentials.getUsername()});
                        Events.instance().raiseEvent("org.xdi.oxauth.security.loginSuccessful", new Object[]{this.authMode, null});
                    }
                    this.log.info((Object)"Authentication success for User: {0}", new Object[]{this.credentials.getUsername()});
                    return true;
                }
            } else {
                boolean authenticated;
                if (this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.SERVICE)) {
                    ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration = this.externalAuthenticationService.determineExternalAuthenticatorConfiguration(AuthenticationScriptUsageType.SERVICE, 1, this.authLevel, this.authMode);
                    if (externalAuthenticatorConfiguration == null) {
                        this.log.error((Object)"Failed to get ExternalAuthenticatorConfiguration. auth_step: {0}, auth_mode: {1}, auth_level: {2}", new Object[]{this.authStep, this.authMode, this.authLevel});
                    } else {
                        this.authMode = externalAuthenticatorConfiguration.getName();
                        boolean result = this.externalAuthenticationService.executeExternalAuthenticatorAuthenticate(externalAuthenticatorConfiguration, null, 1);
                        this.log.info((Object)"Authentication result for {0}. auth_step: {1}, result: {2}", new Object[]{this.credentials.getUsername(), this.authStep, result});
                        if (result) {
                            this.authenticateExternallyWebService(this.credentials.getUsername());
                            this.authenticationService.configureEventUser(interactive);
                            this.log.info((Object)"Authentication success for User: {0}", new Object[]{this.credentials.getUsername()});
                            return true;
                        }
                    }
                }
                if (StringHelper.isNotEmpty((String)this.credentials.getUsername()) && (authenticated = this.authenticationService.authenticate(this.credentials.getUsername(), this.credentials.getPassword()))) {
                    this.authenticateExternallyWebService(this.credentials.getUsername());
                    this.authenticationService.configureEventUser(interactive);
                    this.log.info((Object)"Authentication success for User: {0}", new Object[]{this.credentials.getUsername()});
                    return true;
                }
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        this.log.info((Object)"Authentication failed for {0}", new Object[]{this.credentials.getUsername()});
        return false;
    }

    private void initCustomAuthenticatorVariables(Map<String, String> restoredRequestParametersFromSession) {
        Map<String, String> requestParameters = restoredRequestParametersFromSession;
        if (restoredRequestParametersFromSession == null) {
            return;
        }
        this.authStep = StringHelper.toInteger((String)requestParameters.get("auth_step"), null);
        this.authLevel = requestParameters.get("auth_level");
        this.authMode = requestParameters.get("auth_mode");
        this.authAmr = requestParameters.get("amr");
    }

    public String prepareAuthenticationForStep() {
        this.setAuthModeFromAmr();
        if (this.authMode == null) {
            return "success";
        }
        if (this.authStep == null || this.authStep < 1) {
            return "no_permissions";
        }
        ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration = this.externalAuthenticationService.determineExternalAuthenticatorConfiguration(AuthenticationScriptUsageType.INTERACTIVE, this.authStep, this.authLevel, this.authMode);
        String currentAuthMode = externalAuthenticatorConfiguration.getName();
        if (externalAuthenticatorConfiguration == null) {
            this.log.error((Object)"Failed to get ExternalAuthenticatorConfiguration. auth_step: '{0}', auth_mode: '{1}'", new Object[]{this.authStep, this.authMode});
            return "failure";
        }
        if ((externalAuthenticatorConfiguration = this.externalAuthenticationService.determineExternalAuthenticatorForWorkflow(AuthenticationScriptUsageType.INTERACTIVE, externalAuthenticatorConfiguration)) == null) {
            return "failure";
        }
        String determinedAuthMode = externalAuthenticatorConfiguration.getName();
        if (!StringHelper.equalsIgnoreCase((String)currentAuthMode, (String)determinedAuthMode)) {
            String redirectTo = this.externalAuthenticationService.executeExternalAuthenticatorGetPageForStep(externalAuthenticatorConfiguration, this.authStep);
            if (StringHelper.isEmpty((String)redirectTo)) {
                redirectTo = "/login.xhtml";
            }
            this.log.debug((Object)"Redirect to page: {0}. Force to use auth_mode: '{1}'", new Object[]{redirectTo, determinedAuthMode});
            Map<String, String> parametersMap = this.authenticationService.getParametersMap(null);
            parametersMap.put("auth_mode", determinedAuthMode);
            FacesManager.instance().redirect(redirectTo, parametersMap, false);
            return "success";
        }
        ExternalContext extCtx = FacesContext.getCurrentInstance().getExternalContext();
        Boolean result = this.externalAuthenticationService.executeExternalAuthenticatorPrepareForStep(externalAuthenticatorConfiguration, extCtx.getRequestParameterValuesMap(), this.authStep);
        if (result == null) {
            return "failure";
        }
        if (result.booleanValue()) {
            return "success";
        }
        return "failure";
    }

    public void authenticateExternallyWebService(String userName) {
        Application application = (Application)Component.getInstance(Application.class);
        if (application != null && !application.isDestroySessionAfterRequest()) {
            SimplePrincipal principal = new SimplePrincipal(userName);
            this.identity.acceptExternallyAuthenticatedPrincipal((Principal)principal);
            this.identity.quietLogin();
        }
    }

    public void configureSessionClient(Context context) {
        this.identity.addRole("client");
        Client client = this.clientService.getClient(this.credentials.getUsername());
        SessionClient sessionClient = new SessionClient();
        sessionClient.setClient(client);
        context.set("sessionClient", (Object)sessionClient);
        this.clientService.updatAccessTime(client, true);
    }

    public int getCurrentAuthenticationStep() {
        return this.authStep;
    }

    public void setCurrentAuthenticationStep(int currentAuthenticationStep) {
        this.authStep = currentAuthenticationStep;
    }

    public boolean authenticationFailed() {
        this.facesMessages.addFromResourceBundle(StatusMessage.Severity.ERROR, "login.errorMessage", new Object[0]);
        return false;
    }

    public boolean authenticateBySessionId(String p_sessionId) {
        if (StringUtils.isNotBlank((String)p_sessionId) && ConfigurationFactory.getConfiguration().getSessionIdEnabled().booleanValue()) {
            try {
                User user;
                SessionId sessionId = this.sessionIdService.getSessionId(p_sessionId);
                this.log.trace((Object)"authenticateBySessionId, sessionId = {0}, session = {1}", new Object[]{p_sessionId, sessionId});
                if (sessionId != null && (user = this.getUserOrRemoveSession(sessionId)) != null) {
                    this.authenticateExternallyWebService(user.getUserId());
                    this.authenticationService.configureEventUser(sessionId, new ArrayList<Prompt>(Arrays.asList(Prompt.NONE)));
                    return true;
                }
            }
            catch (Exception e) {
                this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        return false;
    }

    private User getUserOrRemoveSession(SessionId p_sessionId) {
        if (p_sessionId != null) {
            try {
                if (StringUtils.isNotBlank((String)p_sessionId.getUserDn())) {
                    User user = this.userService.getUserByDn(p_sessionId.getUserDn());
                    if (user != null) {
                        return user;
                    }
                    this.sessionIdService.remove(p_sessionId);
                } else {
                    this.sessionIdService.remove(p_sessionId);
                }
            }
            catch (Exception e) {
                this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        return null;
    }

    private void setAuthModeFromAmr() {
        if (StringHelper.isNotEmpty((String)this.authAmr)) {
            this.authMode = this.authAmr;
        }
    }
}

