/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.model.authorize.Claim;
import org.xdi.oxauth.client.model.authorize.ClaimValue;
import org.xdi.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterResponseParam;
import org.xdi.oxauth.model.util.StringUtils;

public class OpenIDRequestObjectWithRSAlgEmbeddedTest
extends BaseTest {
    private String clientId1;
    private String clientId2;
    private String clientId3;
    private String clientId4;
    private String clientId5;
    private String clientId6;

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodRS256Step1(String registerPath, final String redirectUris, final String jwksUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setJwksUri(jwksUri);
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS256Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId1 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "RS256_modulus", "RS256_privateExponent"})
    @Test(dependsOnMethods={"requestParameterMethodRS256Step1"})
    public void requestParameterMethodRS256Step2(String authorizePath, final String userId, final String userSecret, final String redirectUri, final String modulus, final String privateExponent) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                RSAPrivateKey privateKey = new RSAPrivateKey(modulus, privateExponent);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                String state = "af0ifjsldkj";
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId1, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.RS256, privateKey);
                jwtAuthorizationRequest.setKeyId("RS256SIG");
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS256Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getQuery(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodRS384Step1(String registerPath, final String redirectUris, final String jwksUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setJwksUri(jwksUri);
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS384);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS384Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId2 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "RS384_modulus", "RS384_privateExponent"})
    @Test(dependsOnMethods={"requestParameterMethodRS384Step1"})
    public void requestParameterMethodRS384Step2(String authorizePath, final String userId, final String userSecret, final String redirectUri, final String modulus, final String privateExponent) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                RSAPrivateKey privateKey = new RSAPrivateKey(modulus, privateExponent);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                String state = "af0ifjsldkj";
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId2, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.RS384, privateKey);
                jwtAuthorizationRequest.setKeyId("RS384SIG");
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS384Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getQuery(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodRS512Step1(String registerPath, final String redirectUris, final String jwksUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setJwksUri(jwksUri);
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS512);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS512Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId3 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "RS512_modulus", "RS512_privateExponent"})
    @Test(dependsOnMethods={"requestParameterMethodRS512Step1"})
    public void requestParameterMethodRS512Step2(String authorizePath, final String userId, final String userSecret, final String redirectUri, final String modulus, final String privateExponent) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                RSAPrivateKey privateKey = new RSAPrivateKey(modulus, privateExponent);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                String state = "af0ifjsldkj";
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId3, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.RS512, privateKey);
                jwtAuthorizationRequest.setKeyId("RS512SIG");
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS512Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getQuery(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodRS256X509CertStep1(String registerPath, final String redirectUris, final String jwksUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setJwksUri(jwksUri);
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS256X509CertStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId4 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "RS256_modulus", "RS256_privateExponent"})
    @Test(dependsOnMethods={"requestParameterMethodRS256X509CertStep1"})
    public void requestParameterMethodRS256X509CertStep2(String authorizePath, final String userId, final String userSecret, final String redirectUri, final String modulus, final String privateExponent) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                RSAPrivateKey privateKey = new RSAPrivateKey(modulus, privateExponent);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                String state = "af0ifjsldkj";
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId4, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.RS256, privateKey);
                jwtAuthorizationRequest.setKeyId("RS256SIG");
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS256X509CertStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getQuery(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodRS384X509CertStep1(String registerPath, final String redirectUris, final String jwksUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setJwksUri(jwksUri);
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS384);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS384X509CertStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId5 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "RS384_modulus", "RS384_privateExponent"})
    @Test(dependsOnMethods={"requestParameterMethodRS384X509CertStep1"})
    public void requestParameterMethodRS384X509CertStep2(String authorizePath, final String userId, final String userSecret, final String redirectUri, final String modulus, final String privateExponent) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                RSAPrivateKey privateKey = new RSAPrivateKey(modulus, privateExponent);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                String state = "af0ifjsldkj";
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId5, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.RS384, privateKey);
                jwtAuthorizationRequest.setKeyId("RS384SIG");
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS384X509CertStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getQuery(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestParameterMethodRS512X509CertStep1(String registerPath, final String redirectUris, final String jwksUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setJwksUri(jwksUri);
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS512);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS512X509CertStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId6 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "RS512_modulus", "RS512_privateExponent"})
    @Test(dependsOnMethods={"requestParameterMethodRS512X509CertStep1"})
    public void requestParameterMethodRS512X509CertStep2(String authorizePath, final String userId, final String userSecret, final String redirectUri, final String modulus, final String privateExponent) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                RSAPrivateKey privateKey = new RSAPrivateKey(modulus, privateExponent);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                String state = "af0ifjsldkj";
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectWithRSAlgEmbeddedTest.this.clientId6, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.RS512, privateKey);
                jwtAuthorizationRequest.setKeyId("RS512SIG");
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodRS512X509CertStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getQuery(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }
}

