/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import org.apache.commons.lang.StringUtils;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.FederationDataRequest;
import org.xdi.oxauth.client.FederationDataResponse;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.federation.FederationErrorResponseType;
import org.xdi.oxauth.model.federation.FederationRequest;

public class FederationDataEmbeddedTest
extends BaseTest {
    public static void assertErrorResponse(EnhancedMockHttpServletResponse p_response, IErrorType p_errorType) {
        Assert.assertEquals((int)p_response.getStatus(), (int)400, (String)("Unexpected response code. Entity: " + p_response.getContentAsString()));
        Assert.assertNotNull((Object)p_response.getContentAsString(), (String)"The entity is null");
        FederationDataResponse r = new FederationDataResponse();
        r.injectErrorIfExistSilently(p_response.getContentAsString());
        Assert.assertEquals((Object)r.getErrorType(), (Object)p_errorType);
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)r.getErrorDescription()));
    }

    @Parameters(value={"federationPath", "federationMetadataId", "federationRpDisplayName", "federationRpRedirectUri"})
    @Test
    public void requestRpJoin(String federationPath, final String federationMetadataId, final String federationRpDisplayName, final String federationRpRedirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, federationPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                FederationDataRequest r = new FederationDataRequest(FederationRequest.Type.RP);
                r.setFederationId(federationMetadataId);
                r.setDisplayName(federationRpDisplayName);
                r.setRedirectUri(federationRpRedirectUri);
                request.addParameters(r.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestRpJoin", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
            }
        }.run();
    }

    @Parameters(value={"federationPath", "federationMetadataId", "federationRpDisplayName", "federationRpRedirectUris"})
    @Test
    public void requestRpJoinWithMultipleUris(String federationPath, final String federationMetadataId, final String federationRpDisplayName, final String federationRpRedirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, federationPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                FederationDataRequest r = new FederationDataRequest(FederationRequest.Type.RP);
                r.setFederationId(federationMetadataId);
                r.setDisplayName(federationRpDisplayName);
                r.setRedirectUri(federationRpRedirectUris);
                request.addParameters(r.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestRpJoinWithMultipleUris", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
            }
        }.run();
    }

    @Parameters(value={"federationPath", "federationMetadataId", "federationOpDisplayName", "federationOpId", "federationOpDomain"})
    @Test
    public void requestOpJoin(String federationPath, final String federationMetadataId, final String federationOpDisplayName, final String federationOpId, final String federationOpDomain) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, federationPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                FederationDataRequest r = new FederationDataRequest(FederationRequest.Type.OP);
                r.setFederationId(federationMetadataId);
                r.setDisplayName(federationOpDisplayName);
                r.setOpId(federationOpId);
                r.setDomain(federationOpDomain);
                request.addParameters(r.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestOpJoin", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
            }
        }.run();
    }

    @Parameters(value={"federationPath", "federationRpDisplayName", "federationRpRedirectUri"})
    @Test
    public void requestRpJoinFailWithInvalidFederationMetadataId(String federationPath, final String federationRpDisplayName, final String federationRpRedirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, federationPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                FederationDataRequest r = new FederationDataRequest(FederationRequest.Type.RP);
                r.setFederationId("dsf");
                r.setDisplayName(federationRpDisplayName);
                r.setRedirectUri(federationRpRedirectUri);
                request.addParameters(r.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestRpJoinFailWithInvalidFederationMetadataId", response);
                FederationDataEmbeddedTest.assertErrorResponse(response, (IErrorType)FederationErrorResponseType.INVALID_FEDERATION_ID);
            }
        }.run();
    }

    @Parameters(value={"federationPath", "federationMetadataId", "federationRpRedirectUri"})
    @Test
    public void requestRpJoinFailWithInvalidDisplayName(String federationPath, final String federationMetadataId, final String federationRpRedirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, federationPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                FederationDataRequest r = new FederationDataRequest(FederationRequest.Type.RP);
                r.setFederationId(federationMetadataId);
                r.setDisplayName("");
                r.setRedirectUri(federationRpRedirectUri);
                request.addParameters(r.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestRpJoinFailWithInvalidDisplayName", response);
                FederationDataEmbeddedTest.assertErrorResponse(response, (IErrorType)FederationErrorResponseType.INVALID_DISPLAY_NAME);
            }
        }.run();
    }

    @Parameters(value={"federationPath", "federationMetadataId", "federationRpDisplayName"})
    @Test
    public void requestRpJoinFailWithInvalidRedirectUri(String federationPath, final String federationMetadataId, final String federationRpDisplayName) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, federationPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                FederationDataRequest r = new FederationDataRequest(FederationRequest.Type.RP);
                r.setFederationId(federationMetadataId);
                r.setDisplayName(federationRpDisplayName);
                r.setRedirectUri("");
                request.addParameters(r.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestRpJoinFailWithInvalidRedirectUri", response);
                FederationDataEmbeddedTest.assertErrorResponse(response, (IErrorType)FederationErrorResponseType.INVALID_REDIRECT_URI);
            }
        }.run();
    }

    @Parameters(value={"federationPath", "federationMetadataId", "federationOpDisplayName", "federationOpDomain"})
    @Test
    public void requestOpJoinFailWithInvalidOpId(String federationPath, final String federationMetadataId, final String federationOpDisplayName, final String federationOpDomain) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, federationPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                FederationDataRequest r = new FederationDataRequest(FederationRequest.Type.OP);
                r.setFederationId(federationMetadataId);
                r.setDisplayName(federationOpDisplayName);
                r.setOpId("");
                r.setDomain(federationOpDomain);
                request.addParameters(r.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestOpJoinFailWithInvalidOpId", response);
                FederationDataEmbeddedTest.assertErrorResponse(response, (IErrorType)FederationErrorResponseType.INVALID_OP_ID);
            }
        }.run();
    }

    @Parameters(value={"federationPath", "federationMetadataId", "federationOpDisplayName", "federationOpId"})
    @Test
    public void requestOpJoinFailWithInvalidDomain(String federationPath, final String federationMetadataId, final String federationOpDisplayName, final String federationOpId) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, federationPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                FederationDataRequest r = new FederationDataRequest(FederationRequest.Type.OP);
                r.setFederationId(federationMetadataId);
                r.setDisplayName(federationOpDisplayName);
                r.setOpId(federationOpId);
                r.setDomain("");
                request.addParameters(r.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestOpJoinFailWithInvalidDomain", response);
                FederationDataEmbeddedTest.assertErrorResponse(response, (IErrorType)FederationErrorResponseType.INVALID_DOMAIN);
            }
        }.run();
    }
}

