/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseMode;
import org.xdi.oxauth.model.common.ResponseType;

public class AuthorizeWithResponseModeEmbeddedTest
extends BaseTest {
    @Parameters(value={"authorizePath", "userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void requestAuthorizationCodeWithResponseModeQuery(String authorizePath, final String userId, final String userSecret, final String clientId, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.CODE);
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("openid");
                scopes.add("profile");
                scopes.add("address");
                scopes.add("email");
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                authorizationRequest.setResponseMode(ResponseMode.QUERY);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAuthorizationCodeWithResponseModeQuery", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getQuery(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getQuery());
                    Assert.assertNotNull(params.get("code"), (String)"The code is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void requestAuthorizationCodeWithResponseModeFragment(String authorizePath, final String userId, final String userSecret, final String clientId, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.CODE);
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("openid");
                scopes.add("profile");
                scopes.add("address");
                scopes.add("email");
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                authorizationRequest.setResponseMode(ResponseMode.FRAGMENT);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAuthorizationCodeWithResponseModeFragment", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("code"), (String)"The code is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void requestAuthorizationTokenWithResponseModeQuery(String authorizePath, final String userId, final String userSecret, final String clientId, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.TOKEN);
                responseTypes.add(ResponseType.ID_TOKEN);
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("openid");
                scopes.add("profile");
                scopes.add("address");
                scopes.add("email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                authorizationRequest.setResponseMode(ResponseMode.QUERY);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAuthorizationTokenWithResponseModeQuery", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getQuery(), (String)"Query is null");
                        Map params = QueryStringDecoder.decode((String)uri.getQuery());
                        Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                        Assert.assertNotNull(params.get("expires_in"), (String)"The expires in value is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                        Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void requestAuthorizationTokenWithResponseModeFragment(String authorizePath, final String userId, final String userSecret, final String clientId, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.TOKEN);
                responseTypes.add(ResponseType.ID_TOKEN);
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("openid");
                scopes.add("profile");
                scopes.add("address");
                scopes.add("email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                authorizationRequest.setResponseMode(ResponseMode.FRAGMENT);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAuthorizationTokenWithResponseModeFragment", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                        Assert.assertNotNull(params.get("expires_in"), (String)"The expires in value is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                        Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                }
            }
        }.run();
    }
}

