/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import java.io.IOException;
import java.util.Arrays;
import javax.ws.rs.core.Response;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.uma.ResourceSetPermissionRequest;
import org.xdi.oxauth.model.uma.ResourceSetPermissionTicket;
import org.xdi.oxauth.model.uma.ResourceSetStatus;
import org.xdi.oxauth.model.uma.TUma;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.util.ServerUtil;

public class RegisterPermissionWSTest
extends BaseTest {
    private Token m_pat;
    private ResourceSetStatus m_resourceSet;
    private String m_umaRegisterResourcePath;
    private String m_umaPermissionPath;

    @Test
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri", "umaRegisterResourcePath", "umaPermissionPath"})
    public void init_(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri, String umaRegisterResourcePath, String p_umaPermissionPath) {
        this.m_umaRegisterResourcePath = umaRegisterResourcePath;
        this.m_umaPermissionPath = p_umaPermissionPath;
        this.m_pat = TUma.requestPat(this, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_pat);
    }

    @Test(dependsOnMethods={"init_"})
    public void init() {
        this.m_resourceSet = TUma.registerResourceSet(this, this.m_pat, this.m_umaRegisterResourcePath, UmaTestUtil.createResourceSet());
        UmaTestUtil.assert_((ResourceSetStatus)this.m_resourceSet);
    }

    @Test(dependsOnMethods={"init"})
    @Parameters(value={"umaAmHost", "umaHost"})
    public void testRegisterPermission(String umaAmHost, String umaHost) throws Exception {
        ResourceSetPermissionRequest r = new ResourceSetPermissionRequest();
        r.setResourceSetId(this.m_resourceSet.getId());
        r.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view"));
        ResourceSetPermissionTicket ticket = TUma.registerPermission(this, this.m_pat, umaAmHost, umaHost, r, this.m_umaPermissionPath);
        UmaTestUtil.assert_((ResourceSetPermissionTicket)ticket);
    }

    @Test(dependsOnMethods={"testRegisterPermission"})
    @Parameters(value={"umaAmHost", "umaHost"})
    public void testRegisterPermissionWithInvalidResourceSet(final String umaAmHost, String umaHost) {
        final ResourceSetPermissionRequest r = new ResourceSetPermissionRequest();
        r.setResourceSetId(this.m_resourceSet.getId() + "x");
        String path = this.m_umaPermissionPath + "/" + umaHost + "/";
        try {
            new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.PUT, path){

                protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                    super.prepareRequest(request);
                    request.addHeader("Accept", (Object)"application/json");
                    request.addHeader("Authorization", (Object)("Bearer " + RegisterPermissionWSTest.this.m_pat.getAccessToken()));
                    request.addHeader("Host", (Object)umaAmHost);
                    try {
                        String json = ServerUtil.createJsonMapper().writeValueAsString((Object)r);
                        request.setContent(Util.getBytes((String)json));
                        request.setContentType("application/json");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Assert.fail();
                    }
                }

                protected void onResponse(EnhancedMockHttpServletResponse response) {
                    super.onResponse(response);
                    BaseTest.showResponse("UMA : RegisterPermissionWSTest.testRegisterPermissionWithInvalidResourceSet() : ", response);
                    Assert.assertEquals((int)response.getStatus(), (int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Unexpected response code.");
                    try {
                        ResourceSetPermissionTicket t = (ResourceSetPermissionTicket)ServerUtil.createJsonMapper().readValue(response.getContentAsString(), ResourceSetPermissionTicket.class);
                        Assert.assertNull((Object)t);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test(dependsOnMethods={"testRegisterPermissionWithInvalidResourceSet"})
    public void cleanUp() {
        if (this.m_resourceSet != null) {
            TUma.deleteResourceSet(this, this.m_pat, this.m_umaRegisterResourcePath, this.m_resourceSet.getId(), this.m_resourceSet.getRev());
        }
    }
}

