/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.uma.AuthorizationResponse;
import org.xdi.oxauth.model.uma.RequesterPermissionTokenResponse;
import org.xdi.oxauth.model.uma.ResourceSetPermissionRequest;
import org.xdi.oxauth.model.uma.ResourceSetPermissionTicket;
import org.xdi.oxauth.model.uma.ResourceSetStatus;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.RptStatusRequest;
import org.xdi.oxauth.model.uma.RptStatusResponse;
import org.xdi.oxauth.model.uma.TUma;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;

public class AccessProtectedResourceFlowWSTest
extends BaseTest {
    private Token m_pat;
    private Token m_aat;
    private RequesterPermissionTokenResponse m_rpt;
    private ResourceSetStatus m_resourceSet;
    private ResourceSetPermissionTicket m_ticket;

    @Test
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void init_0(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) {
        this.m_pat = TUma.requestPat(this, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_pat);
    }

    @Test(dependsOnMethods={"init_0"})
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void init_1(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) {
        this.m_aat = TUma.requestAat(this, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_aat);
    }

    @Test(dependsOnMethods={"init_1"})
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void init_2(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) {
        this.m_aat = TUma.requestAat(this, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_aat);
    }

    @Test(dependsOnMethods={"init_2"})
    @Parameters(value={"umaRptPath", "umaAmHost"})
    public void init(String umaRptPath, String umaAmHost) {
        this.m_rpt = TUma.requestRpt(this, this.m_aat, umaRptPath, umaAmHost);
        UmaTestUtil.assert_((RequesterPermissionTokenResponse)this.m_rpt);
    }

    @Test(dependsOnMethods={"init"})
    @Parameters(value={"umaRegisterResourcePath"})
    public void _1_registerResourceSet(String umaRegisterResourcePath) throws Exception {
        this.m_resourceSet = TUma.registerResourceSet(this, this.m_pat, umaRegisterResourcePath, UmaTestUtil.createResourceSet());
        UmaTestUtil.assert_((ResourceSetStatus)this.m_resourceSet);
    }

    @Test(dependsOnMethods={"_1_registerResourceSet"})
    public void _2_requesterAccessProtectedResourceWithNotEnoughPermissionsRpt() throws Exception {
        this.showTitle("_2_requesterAccessProtectedResourceWithNotEnoughPermissionsRpt");
    }

    @Test(dependsOnMethods={"_2_requesterAccessProtectedResourceWithNotEnoughPermissionsRpt"})
    @Parameters(value={"umaRptStatusPath", "umaAmHost"})
    public void _3_hostDeterminesRptStatus(String umaRptStatusPath, String umaAmHost) throws Exception {
        RptStatusRequest request = new RptStatusRequest();
        request.setRpt(this.m_rpt.getToken());
        request.setResourceSetId(this.m_resourceSet.getId());
        RptStatusResponse status = TUma.requestRptStatus(this, umaRptStatusPath, umaAmHost, this.m_pat, request);
        Assert.assertTrue((boolean)status.getActive(), (String)"Token response status is not active");
        Assert.assertTrue((status.getPermissions() == null || status.getPermissions().isEmpty() ? 1 : 0) != 0, (String)"Permissions list is not empty.");
    }

    @Test(dependsOnMethods={"_3_hostDeterminesRptStatus"})
    @Parameters(value={"umaAmHost", "umaHost", "umaPermissionPath"})
    public void _4_registerPermissionForRpt(String umaAmHost, String umaHost, String umaPermissionPath) throws Exception {
        ResourceSetPermissionRequest r = new ResourceSetPermissionRequest();
        r.setResourceSetId(this.m_resourceSet.getId());
        r.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view"));
        this.m_ticket = TUma.registerPermission(this, this.m_pat, umaAmHost, umaHost, r, umaPermissionPath);
        UmaTestUtil.assert_((ResourceSetPermissionTicket)this.m_ticket);
    }

    @Test(dependsOnMethods={"_4_registerPermissionForRpt"})
    @Parameters(value={"umaPermissionAuthorizationPath", "umaAmHost"})
    public void _5_authorizePermission(String umaPermissionAuthorizationPath, String umaAmHost) {
        RptAuthorizationRequest request = new RptAuthorizationRequest();
        request.setRpt(this.m_rpt.getToken());
        request.setTicket(this.m_ticket.getTicket());
        AuthorizationResponse response = TUma.requestAuthorization(this, umaPermissionAuthorizationPath, umaAmHost, this.m_aat, request);
        Assert.assertNotNull((Object)response, (String)"Token response status is null");
    }

    @Test(dependsOnMethods={"_5_authorizePermission"})
    @Parameters(value={"umaRptStatusPath", "umaAmHost"})
    public void _6_hostDeterminesRptStatus(String umaRptStatusPath, String umaAmHost) throws Exception {
        RptStatusRequest request = new RptStatusRequest();
        request.setRpt(this.m_rpt.getToken());
        request.setResourceSetId(this.m_resourceSet.getId());
        RptStatusResponse status = TUma.requestRptStatus(this, umaRptStatusPath, umaAmHost, this.m_pat, request);
        UmaTestUtil.assert_((RptStatusResponse)status);
    }

    @Test(dependsOnMethods={"_6_hostDeterminesRptStatus"})
    public void _7_requesterAccessProtectedResourceWithEnoughPermissionsRpt() throws Exception {
        this.showTitle("_7_requesterAccessProtectedResourceWithEnoughPermissionsRpt");
    }

    @Test(dependsOnMethods={"_7_requesterAccessProtectedResourceWithEnoughPermissionsRpt"})
    @Parameters(value={"umaRegisterResourcePath"})
    public void cleanUp(String umaRegisterResourcePath) {
        if (this.m_resourceSet != null) {
            TUma.deleteResourceSet(this, this.m_pat, umaRegisterResourcePath, this.m_resourceSet.getId(), this.m_resourceSet.getRev());
        }
    }
}

