/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Holder;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.uma.RequesterPermissionTokenResponse;
import org.xdi.oxauth.model.uma.RptStatusRequest;
import org.xdi.oxauth.model.uma.RptStatusResponse;
import org.xdi.oxauth.model.uma.UmaScopeType;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.util.ServerUtil;

class TTokenRequest {
    private final BaseTest m_baseTest;
    private final Token m_token = new Token();

    public TTokenRequest(BaseTest p_baseTest) {
        Assert.assertNotNull((Object)((Object)p_baseTest));
        this.m_baseTest = p_baseTest;
    }

    public Token pat(String authorizePath, String tokenPath, String userId, String userSecret, String umaClientId, String umaClientSecret, String umaRedirectUri) {
        return this.internalRequest(authorizePath, tokenPath, userId, userSecret, umaClientId, umaClientSecret, umaRedirectUri, UmaScopeType.PROTECTION);
    }

    public Token aat(String authorizePath, String tokenPath, String userId, String userSecret, String umaClientId, String umaClientSecret, String umaRedirectUri) {
        return this.internalRequest(authorizePath, tokenPath, userId, userSecret, umaClientId, umaClientSecret, umaRedirectUri, UmaScopeType.AUTHORIZATION);
    }

    public Token newTokenByRefreshToken(String tokenPath, final Token p_oldToken, final String umaClientId, final String umaClientSecret) {
        if (p_oldToken == null || StringUtils.isBlank((String)p_oldToken.getRefreshToken()) || StringUtils.isBlank((String)tokenPath)) {
            throw new IllegalArgumentException("Refresh token or tokenPath is empty.");
        }
        final Holder t = new Holder();
        try {
            new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.POST, tokenPath){

                protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                    super.prepareRequest(request);
                    TokenRequest tokenRequest = new TokenRequest(GrantType.REFRESH_TOKEN);
                    tokenRequest.setAuthUsername(umaClientId);
                    tokenRequest.setAuthPassword(umaClientSecret);
                    tokenRequest.setRefreshToken(p_oldToken.getRefreshToken());
                    tokenRequest.setScope(p_oldToken.getScope());
                    request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                    request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                    request.addParameters(tokenRequest.getParameters());
                }

                protected void onResponse(EnhancedMockHttpServletResponse response) {
                    super.onResponse(response);
                    BaseTest.showResponse("TTokenClient.requestToken() :", response);
                    Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                    try {
                        JSONObject jsonObj = new JSONObject(response.getContentAsString());
                        Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                        Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                        Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                        String accessToken = jsonObj.getString("access_token");
                        String refreshToken = jsonObj.getString("refresh_token");
                        Token newToken = new Token();
                        newToken.setAccessToken(accessToken);
                        newToken.setRefreshToken(refreshToken);
                        t.setT((Object)newToken);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            }.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return (Token)t.getT();
    }

    private Token internalRequest(String authorizePath, String tokenPath, String userId, String userSecret, String umaClientId, String umaClientSecret, String umaRedirectUri, UmaScopeType p_scopeType) {
        try {
            this.requestAuthorizationCode(authorizePath, userId, userSecret, umaClientId, umaRedirectUri, p_scopeType);
            this.requestToken(tokenPath, umaClientId, umaClientSecret, umaRedirectUri);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        UmaTestUtil.assert_((Token)this.m_token);
        return this.m_token;
    }

    private void requestAuthorizationCode(String authorizePath, final String userId, final String userSecret, final String umaClientId, final String umaRedirectUri, final UmaScopeType p_scopeType) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.CODE);
                responseTypes.add(ResponseType.ID_TOKEN);
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add(p_scopeType.getValue());
                String state = "af0ifjsldkj";
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, umaClientId, scopes, umaRedirectUri, null);
                authorizationRequest.setState(state);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("TTokenClient.requestAuthorizationCode() : ", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        String location = response.getHeader("Location").toString();
                        int fragmentIndex = location.indexOf("#");
                        Map params = new HashMap();
                        if (fragmentIndex != -1) {
                            String fragment = location.substring(fragmentIndex + 1);
                            params = QueryStringDecoder.decode((String)fragment);
                        } else {
                            int queryStringIndex = location.indexOf("?");
                            if (queryStringIndex != -1) {
                                String queryString = location.substring(queryStringIndex + 1);
                                params = QueryStringDecoder.decode((String)queryString);
                            }
                        }
                        Assert.assertNotNull(params.get("code"), (String)"The code is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        TTokenRequest.this.m_token.setAuthorizationCode((String)params.get("code"));
                        TTokenRequest.this.m_token.setScope((String)params.get("scope"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        }.run();
    }

    private void requestToken(String tokenPath, final String umaClientId, final String umaClientSecret, final String umaRedirectUri) throws Exception {
        if (this.m_token == null || StringUtils.isBlank((String)this.m_token.getAuthorizationCode())) {
            throw new IllegalArgumentException("Authorization code is not initialized.");
        }
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
                tokenRequest.setCode(TTokenRequest.this.m_token.getAuthorizationCode());
                tokenRequest.setRedirectUri(umaRedirectUri);
                tokenRequest.setAuthUsername(umaClientId);
                tokenRequest.setAuthPassword(umaClientSecret);
                tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
                tokenRequest.setScope(TTokenRequest.this.m_token.getScope());
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("TTokenClient.requestToken() :", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    String accessToken = jsonObj.getString("access_token");
                    String refreshToken = jsonObj.getString("refresh_token");
                    TTokenRequest.this.m_token.setAccessToken(accessToken);
                    TTokenRequest.this.m_token.setRefreshToken(refreshToken);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    public RequesterPermissionTokenResponse requestRpt(final Token p_aat, String p_rptPath, final String p_umaAmHost) {
        final Holder h = new Holder();
        try {
            new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.POST, p_rptPath){

                protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                    super.prepareRequest(request);
                    request.addHeader("Accept", (Object)"application/json");
                    request.addHeader("Authorization", (Object)("Bearer " + p_aat.getAccessToken()));
                    request.addHeader("Host", (Object)p_umaAmHost);
                }

                protected void onResponse(EnhancedMockHttpServletResponse response) {
                    super.onResponse(response);
                    BaseTest.showResponse("UMA : TTokenRequest.requestRpt() : ", response);
                    Assert.assertEquals((int)response.getStatus(), (int)Response.Status.CREATED.getStatusCode(), (String)"Unexpected response code.");
                    try {
                        String tokenResponse = response.getContentAsString();
                        JSONObject jsonObj = new JSONObject(response.getContentAsString());
                        if (jsonObj.has("requesterPermissionTokenResponse")) {
                            tokenResponse = jsonObj.get("requesterPermissionTokenResponse").toString();
                        }
                        System.out.println("Token response = " + tokenResponse);
                        RequesterPermissionTokenResponse result = (RequesterPermissionTokenResponse)ServerUtil.createJsonMapper().readValue(tokenResponse, RequesterPermissionTokenResponse.class);
                        UmaTestUtil.assert_((RequesterPermissionTokenResponse)result);
                        h.setT((Object)result);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Assert.fail();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        Assert.fail();
                    }
                }
            }.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return (RequesterPermissionTokenResponse)h.getT();
    }

    public RptStatusResponse requestRptStatus(String p_umaRptStatusPath, String p_umaAmHost, final Token p_aat, final RptStatusRequest p_request) {
        final Holder h = new Holder();
        try {
            new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.POST, p_umaRptStatusPath){

                protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                    super.prepareRequest(request);
                    request.addHeader("Accept", (Object)"application/json");
                    request.addHeader("Authorization", (Object)("Bearer " + p_aat.getAccessToken()));
                    try {
                        String json = ServerUtil.createJsonMapper().writeValueAsString((Object)p_request);
                        request.setContent(Util.getBytes((String)json));
                        request.setContentType("application/json");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Assert.fail();
                    }
                }

                protected void onResponse(EnhancedMockHttpServletResponse response) {
                    super.onResponse(response);
                    BaseTest.showResponse("UMA : TTokenRequest.requestRptStatus() : ", response);
                    Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)"Unexpected response code.");
                    try {
                        RptStatusResponse result = (RptStatusResponse)ServerUtil.createJsonMapper().readValue(response.getContentAsString(), RptStatusResponse.class);
                        Assert.assertNotNull((Object)result);
                        h.setT((Object)result);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Assert.fail();
                    }
                }
            }.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return (RptStatusResponse)h.getT();
    }
}

