/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.common.Holder;
import org.xdi.oxauth.model.uma.AuthorizationResponse;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.util.ServerUtil;

class TAuthorization {
    private final BaseTest m_baseTest;

    public TAuthorization(BaseTest p_baseTest) {
        Assert.assertNotNull((Object)((Object)p_baseTest));
        this.m_baseTest = p_baseTest;
    }

    public AuthorizationResponse requestAuthorization(String p_umaPermissionAuthorizationPath, final String p_umaAmHost, final Token p_aat, final RptAuthorizationRequest p_request) {
        final Holder h = new Holder();
        try {
            new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.POST, p_umaPermissionAuthorizationPath){

                protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                    super.prepareRequest(request);
                    request.addHeader("Accept", (Object)"application/json");
                    request.addHeader("Authorization", (Object)("Bearer " + p_aat.getAccessToken()));
                    request.addHeader("Host", (Object)p_umaAmHost);
                    try {
                        String json = ServerUtil.createJsonMapper().writeValueAsString((Object)p_request);
                        request.setContent(Util.getBytes((String)json));
                        request.setContentType("application/json");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Assert.fail();
                    }
                }

                protected void onResponse(EnhancedMockHttpServletResponse response) {
                    super.onResponse(response);
                    BaseTest.showResponse("UMA : TAuthorization.requestAuthorization() : ", response);
                    Assert.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)"Unexpected response code.");
                    try {
                        AuthorizationResponse result = (AuthorizationResponse)ServerUtil.createJsonMapper().readValue(response.getContentAsString(), AuthorizationResponse.class);
                        h.setT((Object)result);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Assert.fail();
                    }
                }
            }.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return (AuthorizationResponse)h.getT();
    }
}

