/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.model.common.ResponseMode;
import org.xdi.oxauth.model.common.ResponseType;

public class RedirectUri {
    private String baseRedirectUri;
    private List<ResponseType> responseTypes;
    private ResponseMode responseMode;
    private Map<String, String> responseParameters;

    public RedirectUri(String baseRedirectUri, List<ResponseType> responseTypes, ResponseMode responseMode) {
        this.baseRedirectUri = baseRedirectUri;
        this.responseTypes = responseTypes;
        this.responseMode = responseMode;
        this.responseParameters = new HashMap<String, String>();
    }

    public String getBaseRedirectUri() {
        return this.baseRedirectUri;
    }

    public void setBaseRedirectUri(String baseRedirectUri) {
        this.baseRedirectUri = baseRedirectUri;
        this.responseMode = ResponseMode.QUERY;
    }

    public void addResponseParameter(String key, String value) {
        if (StringUtils.isNotBlank((String)key)) {
            this.responseParameters.put(key, value);
        }
    }

    public void parseQueryString(String queryString) {
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&", false);
            while (st.hasMoreElements()) {
                String paramName;
                String nameValueToken = st.nextElement().toString();
                StringTokenizer stParamValue = new StringTokenizer(nameValueToken, "=", false);
                if (stParamValue.countTokens() == 1) {
                    paramName = stParamValue.nextElement().toString();
                    this.responseParameters.put(paramName, null);
                    continue;
                }
                if (stParamValue.countTokens() != 2) continue;
                try {
                    paramName = stParamValue.nextElement().toString();
                    String paramValue = URLDecoder.decode(stParamValue.nextElement().toString(), "UTF-8");
                    this.responseParameters.put(paramName, paramValue);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.responseParameters.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            try {
                sb.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                if (entry.getValue() == null) continue;
                sb.append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    private void appendQuerySymbol(StringBuilder sb) {
        if (!sb.toString().contains("?")) {
            sb.append("?");
        } else {
            sb.append("&");
        }
    }

    private void appendFragmentSymbol(StringBuilder sb) {
        if (!sb.toString().contains("#")) {
            sb.append("#");
        } else {
            sb.append("&");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.baseRedirectUri);
        if (this.responseMode != null) {
            if (this.responseMode == ResponseMode.QUERY) {
                this.appendQuerySymbol(sb);
            } else if (this.responseMode == ResponseMode.FRAGMENT) {
                this.appendFragmentSymbol(sb);
            }
        } else if (this.responseTypes.contains(ResponseType.TOKEN) || this.responseTypes.contains(ResponseType.ID_TOKEN)) {
            this.appendFragmentSymbol(sb);
        } else {
            this.appendQuerySymbol(sb);
        }
        sb.append(this.getQueryString());
        return sb.toString();
    }
}

