/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

public class FileConfiguration {
    private static final Logger log = Logger.getLogger(FileConfiguration.class);
    private String fileName;
    private boolean isResource;
    protected PropertiesConfiguration propertiesConfiguration;
    Properties properties;

    public FileConfiguration(String fileName) {
        this(fileName, false);
    }

    public FileConfiguration(String fileName, boolean isResource) {
        this.fileName = fileName;
        this.isResource = isResource;
        if (isResource) {
            this.loadResourceProperties();
        } else {
            this.loadJbossProperties();
        }
    }

    protected void loadJbossProperties() {
        log.debug((Object)String.format("Loading '%s' configuration file from config folder", this.fileName));
        try {
            this.propertiesConfiguration = new PropertiesConfiguration(this.fileName);
        }
        catch (ConfigurationException ex) {
            log.debug((Object)String.format("Failed to load '%s' configuration file from config folder", this.fileName), (Throwable)ex);
        }
    }

    protected void loadResourceProperties() {
        log.debug((Object)String.format("Loading '%s' configuration file from resources", this.fileName));
        try {
            this.propertiesConfiguration = new PropertiesConfiguration(this.fileName);
        }
        catch (ConfigurationException ex) {
            log.debug((Object)String.format("Failed to load '%s' configuration file from resources", this.fileName), (Throwable)ex);
        }
    }

    public void reloadProperties() {
        this.properties = null;
        if (this.isResource) {
            this.loadResourceProperties();
        } else {
            this.loadJbossProperties();
        }
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            Iterator keys = this.propertiesConfiguration.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.properties.put(key, this.getString(key));
            }
        }
        return this.properties;
    }

    public String getString(String key) {
        String[] values = this.propertiesConfiguration.getStringArray(key);
        if (values.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < values.length - 1; ++i) {
                sb.append(values[i]).append(',');
            }
            sb.append(values[values.length - 1]);
            return sb.toString();
        }
        return null;
    }

    public String[] getStringArray(String key) {
        String[] result = this.propertiesConfiguration.getStringArray(key);
        if (result.length == 1 && result[0].trim().length() == 0) {
            result = new String[]{};
        }
        return result;
    }

    public int getInt(String key) {
        return this.propertiesConfiguration.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (NoSuchElementException ex) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) {
        return this.propertiesConfiguration.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (NoSuchElementException ex) {
            return defaultValue;
        }
    }

    public boolean isKeyExist(String key) {
        Iterator keyIterator = this.propertiesConfiguration.getKeys();
        while (keyIterator.hasNext()) {
            String k = (String)keyIterator.next();
            if (!k.equals(key)) continue;
            return true;
        }
        return false;
    }

    public String getKey(String value) {
        Iterator keyIterator = this.propertiesConfiguration.getKeys();
        while (keyIterator.hasNext()) {
            String k = (String)keyIterator.next();
            String v = this.propertiesConfiguration.getString(k);
            if (!v.equals(value)) continue;
            return k;
        }
        return null;
    }
}

