/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.ResourceSetPermissionRequest;
import org.xdi.oxauth.model.uma.ResourceSetPermissionTicket;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.service.uma.ResourceSetPermissionManager;
import org.xdi.oxauth.service.uma.UmaValidationService;
import org.xdi.oxauth.uma.ws.rs.ResourceSetPermissionRegistrationRestWebService;

@Name(value="resourceSetPermissionRegistrationRestWebService")
public class ResourceSetPermissionRegistrationRestWebServiceImpl
implements ResourceSetPermissionRegistrationRestWebService {
    public static final int DEFAULT_PERMISSION_LIFETIME = 3600;
    @Logger
    private Log log;
    @In
    private TokenService tokenService;
    @In
    private ResourceSetPermissionManager resourceSetPermissionManager;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private UmaValidationService umaValidationService;

    @Override
    public Response registerResourceSetPermission(HttpServletRequest request, String authorization, String amHost, String host, ResourceSetPermissionRequest resourceSetPermissionRequest) {
        try {
            this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
            String validatedAmHost = this.umaValidationService.validateAmHost(amHost);
            String validatedHost = this.umaValidationService.validateHost(host);
            this.umaValidationService.validateResourceSet(authorization, resourceSetPermissionRequest);
            return this.registerResourceSetPermissionImpl(request, authorization, validatedAmHost, validatedHost, resourceSetPermissionRequest);
        }
        catch (Exception ex) {
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private Response registerResourceSetPermissionImpl(HttpServletRequest request, String authorization, String validatedAmHost, String validatedHost, ResourceSetPermissionRequest resourceSetPermissionRequest) {
        ResourceSetPermission resourceSetPermissions = this.resourceSetPermissionManager.createResourceSetPermission(validatedAmHost, validatedHost, resourceSetPermissionRequest, ResourceSetPermissionRegistrationRestWebServiceImpl.rptExpirationDate());
        this.resourceSetPermissionManager.addResourceSetPermission(resourceSetPermissions, this.tokenService.getClientDn(authorization));
        return this.prepareResourceSetPermissionTicketResponse(request, resourceSetPermissions);
    }

    public static Date rptExpirationDate() {
        int lifeTime = ConfigurationFactory.getConfiguration().getUmaRequesterPermissionTokenLifetime();
        if (lifeTime <= 0) {
            lifeTime = 3600;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, lifeTime);
        return calendar.getTime();
    }

    private Response prepareResourceSetPermissionTicketResponse(HttpServletRequest request, ResourceSetPermission resourceSetPermissions) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.CREATED);
        ResourceSetPermissionTicket resourceSetPermissionTiket = new ResourceSetPermissionTicket(resourceSetPermissions.getTicket());
        builder.entity((Object)resourceSetPermissionTiket);
        StringBuffer location = request.getRequestURL().append("/").append(resourceSetPermissions.getConfigurationCode());
        builder.header("Location", (Object)location);
        return builder.build();
    }
}

