/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.token.ws.rs;

import java.security.SignatureException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.hibernate.annotations.common.util.StringHelper;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCodeGrant;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.ClientCredentialsGrant;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.IdToken;
import org.xdi.oxauth.model.common.Mode;
import org.xdi.oxauth.model.common.RefreshToken;
import org.xdi.oxauth.model.common.ResourceOwnerPasswordCredentialsGrant;
import org.xdi.oxauth.model.common.TokenType;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.session.OAuthCredentials;
import org.xdi.oxauth.model.session.SessionClient;
import org.xdi.oxauth.model.token.PersistentJwt;
import org.xdi.oxauth.model.token.TokenErrorResponseType;
import org.xdi.oxauth.model.token.TokenParamsValidator;
import org.xdi.oxauth.service.AuthenticationFilterService;
import org.xdi.oxauth.service.AuthenticationService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.FederationDataService;
import org.xdi.oxauth.service.GrantService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.token.ws.rs.TokenRestWebService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.security.StringEncrypter;

@Name(value="requestTokenRestWebService")
public class TokenRestWebServiceImpl
implements TokenRestWebService {
    @Logger
    private Log log;
    @In
    private OAuthCredentials credentials;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private SessionClient sessionClient;
    @In
    private UserService userService;
    @In
    private ClientService clientService;
    @In
    private AuthenticationFilterService authenticationFilterService;
    @In
    private FederationDataService federationDataService;
    @In
    private AuthenticationService authenticationService;

    @Override
    public Response requestAccessToken(String grantType, String code, String redirectUri, String username, String password, String scope, String assertion, String refreshToken, String oxAuthExchangeToken, String clientId, String clientSecret, HttpServletRequest request, SecurityContext sec) {
        this.log.debug((Object)"Attempting to request access token: grantType = {0}, code = {1}, redirectUri = {2}, username = {3}, refreshToken = {4}, clientId = {5}, ExtraParams = {6}, isSecure = {7}", new Object[]{grantType, code, redirectUri, username, refreshToken, clientId, request.getParameterMap(), sec.isSecure()});
        Mode serverMode = ConfigurationFactory.getConfiguration().getModeEnum();
        scope = ServerUtil.urlDecode(scope);
        Response.ResponseBuilder builder = Response.ok();
        try {
            if (!TokenParamsValidator.validateParams(grantType, code, redirectUri, username, password, scope, assertion, refreshToken, oxAuthExchangeToken)) {
                builder = this.error(400, TokenErrorResponseType.INVALID_REQUEST);
            } else {
                GrantType gt = GrantType.fromString((String)grantType);
                Client client = this.sessionClient.getClient();
                if (client == null) {
                    client = this.clientService.getClient(clientId);
                    this.sessionClient.setClient(client);
                    this.clientService.updatAccessTime(client, false);
                }
                if (ConfigurationFactory.getConfiguration().getFederationEnabled().booleanValue() && !this.federationDataService.hasAnyActiveTrust(client)) {
                    this.log.debug((Object)"Forbid token issuing. Client is not in any trust relationship however federation is enabled for server. Client id: {0}, redirectUris: {1}", new Object[]{client.getClientId(), client.getRedirectUris()});
                    return this.error(400, TokenErrorResponseType.UNAUTHORIZED_CLIENT).build();
                }
                if (gt == GrantType.AUTHORIZATION_CODE) {
                    GrantService grantService = GrantService.instance();
                    AuthorizationCodeGrant authorizationCodeGrant = this.authorizationGrantList.getAuthorizationCodeGrant(client.getClientId(), code);
                    if (authorizationCodeGrant != null) {
                        AccessToken accToken = authorizationCodeGrant.createAccessToken();
                        this.log.debug((Object)"Issuing access token: {0}", new Object[]{accToken.getCode()});
                        RefreshToken reToken = authorizationCodeGrant.createRefreshToken();
                        if (scope != null && !scope.isEmpty()) {
                            scope = authorizationCodeGrant.checkScopesPolicy(scope);
                        }
                        IdToken idToken = null;
                        if (authorizationCodeGrant.getScopes().contains("openid")) {
                            String nonce = authorizationCodeGrant.getNonce();
                            idToken = authorizationCodeGrant.createIdToken(nonce, null, accToken, null);
                        }
                        builder.entity((Object)this.getJSonResponse(accToken, accToken.getTokenType(), accToken.getExpiresIn(), reToken, scope, idToken));
                        switch (serverMode) {
                            case IN_MEMORY: {
                                authorizationCodeGrant.getAuthorizationCode().setUsed(true);
                                break;
                            }
                            case LDAP: {
                                grantService.removeByCode(authorizationCodeGrant.getAuthorizationCode().getCode(), authorizationCodeGrant.getClientId());
                            }
                        }
                    } else {
                        if (serverMode == Mode.LDAP) {
                            grantService.removeAllByAuthorizationCode(code);
                        }
                        builder = this.error(400, TokenErrorResponseType.INVALID_GRANT);
                    }
                } else if (gt == GrantType.REFRESH_TOKEN) {
                    AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByRefreshToken(client.getClientId(), refreshToken);
                    if (authorizationGrant != null) {
                        AccessToken accToken = authorizationGrant.createAccessToken();
                        RefreshToken reToken = authorizationGrant.createRefreshToken();
                        if (scope != null && !scope.isEmpty()) {
                            scope = authorizationGrant.checkScopesPolicy(scope);
                        }
                        IdToken idToken = null;
                        if (authorizationGrant.getScopes().contains("openid")) {
                            idToken = authorizationGrant.createIdToken(null, null, null, null);
                        }
                        builder.entity((Object)this.getJSonResponse(accToken, accToken.getTokenType(), accToken.getExpiresIn(), reToken, scope, idToken));
                    } else {
                        builder = this.error(401, TokenErrorResponseType.INVALID_GRANT);
                    }
                } else if (gt == GrantType.CLIENT_CREDENTIALS) {
                    ClientCredentialsGrant clientCredentialsGrant = this.authorizationGrantList.createClientCredentialsGrant(new User(), client);
                    AccessToken accessToken = clientCredentialsGrant.createAccessToken();
                    if (scope != null && !scope.isEmpty()) {
                        scope = clientCredentialsGrant.checkScopesPolicy(scope);
                    }
                    IdToken idToken = null;
                    if (clientCredentialsGrant.getScopes().contains("openid")) {
                        idToken = clientCredentialsGrant.createIdToken(null, null, null, null);
                    }
                    builder.entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), null, scope, idToken));
                } else if (gt == GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS) {
                    boolean authenticated;
                    String userDn;
                    User user = null;
                    if (this.authenticationFilterService.isEnabled() && StringHelper.isNotEmpty((String)(userDn = this.authenticationFilterService.processAuthenticationFilters(request.getParameterMap())))) {
                        user = this.userService.getUserByDn(userDn);
                    }
                    if (user == null && (authenticated = this.authenticationService.authenticate(username, password))) {
                        user = this.credentials.getUser();
                    }
                    if (user != null) {
                        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = this.authorizationGrantList.createResourceOwnerPasswordCredentialsGrant(user, client);
                        AccessToken accessToken = resourceOwnerPasswordCredentialsGrant.createAccessToken();
                        RefreshToken reToken = resourceOwnerPasswordCredentialsGrant.createRefreshToken();
                        if (scope != null && !scope.isEmpty()) {
                            scope = resourceOwnerPasswordCredentialsGrant.checkScopesPolicy(scope);
                        }
                        IdToken idToken = null;
                        if (resourceOwnerPasswordCredentialsGrant.getScopes().contains("openid")) {
                            idToken = resourceOwnerPasswordCredentialsGrant.createIdToken(null, null, null, null);
                        }
                        builder.entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), reToken, scope, idToken));
                    } else {
                        builder = this.error(401, TokenErrorResponseType.INVALID_CLIENT);
                    }
                } else if (gt == GrantType.EXTENSION) {
                    builder = this.error(501, TokenErrorResponseType.INVALID_GRANT);
                } else if (gt == GrantType.OXAUTH_EXCHANGE_TOKEN) {
                    AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(oxAuthExchangeToken);
                    if (authorizationGrant != null) {
                        AccessToken accessToken = authorizationGrant.createLongLivedAccessToken();
                        ArrayList<String> scopes = new ArrayList<String>();
                        if (authorizationGrant.getScopes() != null) {
                            scopes.addAll(authorizationGrant.getScopes());
                        }
                        PersistentJwt persistentJwt = new PersistentJwt();
                        persistentJwt.setUserId(authorizationGrant.getUserId());
                        persistentJwt.setClientId(authorizationGrant.getClient().getClientId());
                        persistentJwt.setAuthorizationGrantType(authorizationGrant.getAuthorizationGrantType());
                        persistentJwt.setAuthenticationTime(authorizationGrant.getAuthenticationTime());
                        persistentJwt.setScopes(scopes);
                        persistentJwt.setAccessTokens(authorizationGrant.getAccessTokens());
                        persistentJwt.setRefreshTokens(authorizationGrant.getRefreshTokens());
                        persistentJwt.setLongLivedAccessToken(authorizationGrant.getLongLivedAccessToken());
                        persistentJwt.setIdToken(authorizationGrant.getIdToken());
                        if (ConfigurationFactory.getConfiguration().getModeEnum() == Mode.IN_MEMORY) {
                            this.userService.saveLongLivedToken(authorizationGrant.getUserId(), persistentJwt);
                        }
                        builder.entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), null, null, null));
                    } else {
                        builder = this.error(401, TokenErrorResponseType.INVALID_GRANT);
                    }
                }
            }
        }
        catch (SignatureException e) {
            builder = Response.status((int)500);
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (StringEncrypter.EncryptionException e) {
            builder = Response.status((int)500);
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (InvalidJwtException e) {
            builder = Response.status((int)500);
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (InvalidJweException e) {
            builder = Response.status((int)500);
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            builder = Response.status((int)500);
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(false);
        cacheControl.setNoStore(true);
        builder.cacheControl(cacheControl);
        builder.header("Pragma", (Object)"no-cache");
        return builder.build();
    }

    private Response.ResponseBuilder error(int p_status, TokenErrorResponseType p_type) {
        return Response.status((int)p_status).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)p_type));
    }

    public String getJSonResponse(AccessToken accessToken, TokenType tokenType, Integer expiresIn, RefreshToken refreshToken, String scope, IdToken idToken) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("access_token", (Object)accessToken.getCode());
            jsonObj.put("token_type", (Object)tokenType.toString());
            if (expiresIn != null) {
                jsonObj.put("expires_in", (Object)expiresIn);
            }
            if (refreshToken != null) {
                jsonObj.put("refresh_token", (Object)refreshToken.getCode());
            }
            if (scope != null) {
                jsonObj.put("scope", (Object)scope);
            }
            if (idToken != null) {
                jsonObj.put("id_token", (Object)idToken.getCode());
            }
        }
        catch (JSONException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return jsonObj.toString();
    }
}

