/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.discovery.OpenIdConnectDiscoveryParamsValidator;

public class WebFinger
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(WebFinger.class);

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/jrd+json");
        PrintWriter out = response.getWriter();
        String resource = request.getParameter("resource");
        String rel = request.getParameter("rel");
        logger.debug((Object)("Attempting to request OpenID Connect Discovery: " + resource + ", " + rel + ", Is Secure = " + request.isSecure()));
        try {
            if (OpenIdConnectDiscoveryParamsValidator.validateParams(resource, rel) && (rel == null || rel.equals("http://openid.net/specs/connect/1.0/issuer"))) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("subject", (Object)resource);
                JSONArray linksJsonArray = new JSONArray();
                JSONObject linkJsonObject = new JSONObject();
                linkJsonObject.put("rel", (Object)"http://openid.net/specs/connect/1.0/issuer");
                linkJsonObject.put("href", (Object)ConfigurationFactory.getConfiguration().getIssuer());
                linksJsonArray.put((Object)linkJsonObject);
                jsonObj.put("links", (Object)linksJsonArray);
                out.println(jsonObj.toString(4).replace("\\/", "/"));
            }
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "OpenID Connect Discovery";
    }
}

