/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma.authorization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.python.core.PyObject;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.UnmodifiableAuthorizationGrant;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.persistence.ProgrammingLanguage;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.model.uma.persistence.UmaPolicy;
import org.xdi.oxauth.service.uma.PolicyService;
import org.xdi.oxauth.service.uma.authorization.AuthorizationContext;
import org.xdi.oxauth.service.uma.authorization.IPolicyExternalAuthorization;
import org.xdi.oxauth.service.uma.authorization.PolicyExternalAuthorizationEnum;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.service.PythonService;

@Scope(value=ScopeType.STATELESS)
@Name(value="umaAuthorizationService")
@AutoCreate
public class AuthorizationService {
    private static final String PYTHON_CLASS_NAME = "PythonExternalAuthorization";
    @Logger
    private Log log;
    @In
    private PythonService pythonService;
    @In
    private PolicyService umaPolicyService;

    public boolean allowToAddPermission(AuthorizationGrant p_grant, UmaRPT p_rpt, ResourceSetPermission p_permission, HttpServletRequest httpRequest, RptAuthorizationRequest rptAuthorizationRequest) {
        this.log.trace((Object)"Check policies for permission, id: {0}", new Object[]{p_permission.getDn()});
        List<UmaPolicy> umaPolicies = this.umaPolicyService.loadPoliciesByScopeDns(p_permission.getScopeDns());
        if (umaPolicies == null || umaPolicies.isEmpty()) {
            this.log.trace((Object)"No policies protection, allowed to grant permission.", new Object[0]);
            return true;
        }
        UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(p_grant);
        AuthorizationContext context = new AuthorizationContext(p_rpt, p_permission, unmodifiableAuthorizationGrant, httpRequest, rptAuthorizationRequest.getClaims());
        for (UmaPolicy policy : umaPolicies) {
            if (this.applyPolicy(policy, context)) continue;
            this.log.trace((Object)"Reject access. Policy dn: {0}", new Object[]{policy.getDn()});
            return false;
        }
        this.log.trace((Object)"All policies are ok, grant access.", new Object[0]);
        return true;
    }

    private boolean applyPolicy(UmaPolicy p_policy, AuthorizationContext p_context) {
        try {
            this.log.trace((Object)"Apply policy id: {0} ...", new Object[]{p_policy.getInum()});
            ProgrammingLanguage programmingLanguage = p_policy.getProgrammingLanguage();
            if (programmingLanguage != null) {
                switch (programmingLanguage) {
                    case PYTHON: {
                        IPolicyExternalAuthorization pythonAuthorization = this.createPythonAuthorization(p_policy.getPolicyScript());
                        if (pythonAuthorization == null) break;
                        boolean result = pythonAuthorization.authorize(p_context);
                        this.log.trace((Object)"Policy result: {0}", new Object[]{result});
                        return result;
                    }
                    case JAVA_SCRIPT: {
                        this.log.error((Object)"JavaScript is not supported! Please use python instead.", new Object[0]);
                    }
                }
            } else {
                this.log.error((Object)"Unable to identify programming language.", new Object[0]);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPolicyExternalAuthorization createPythonAuthorization(String p_pythonScript) {
        block8: {
            IPolicyExternalAuthorization iPolicyExternalAuthorization;
            if (!StringUtils.isNotBlank((String)p_pythonScript)) break block8;
            ByteArrayInputStream bis = null;
            try {
                bis = new ByteArrayInputStream(p_pythonScript.getBytes("UTF-8"));
                IPolicyExternalAuthorization result = (IPolicyExternalAuthorization)this.pythonService.loadPythonScript((InputStream)bis, PYTHON_CLASS_NAME, IPolicyExternalAuthorization.class, new PyObject[0]);
                if (result == null) {
                    this.log.error((Object)"Policy python script does not implement IPolicyExternalAuthorization interface or script is corrupted.", new Object[0]);
                }
                iPolicyExternalAuthorization = result;
            }
            catch (Exception e) {
                try {
                    try {
                        this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(bis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)bis);
                }
                catch (Exception ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
                }
            }
            IOUtils.closeQuietly((InputStream)bis);
            return iPolicyExternalAuthorization;
        }
        this.log.error((Object)"Failed to prepare python external authorization", new Object[0]);
        this.log.info((Object)"Using FALSE external authorization class.", new Object[0]);
        return PolicyExternalAuthorizationEnum.FALSE;
    }

    public static AuthorizationService instance() {
        return (AuthorizationService)ServerUtil.instance(AuthorizationService.class);
    }
}

