/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma;

import com.unboundid.ldap.sdk.Filter;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.uma.persistence.UmaPolicy;
import org.xdi.oxauth.util.ServerUtil;

@Scope(value=ScopeType.STATELESS)
@Name(value="umaPolicyService")
@AutoCreate
public class PolicyService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    public List<UmaPolicy> loadAllPolicies() {
        try {
            return this.ldapEntryManager.findEntries(PolicyService.baseDn(), UmaPolicy.class, Filter.createPresenceFilter((String)"inum"));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return Collections.emptyList();
        }
    }

    public List<UmaPolicy> loadPoliciesByScopeDns(List<String> p_umaScopeDns) {
        try {
            if (p_umaScopeDns == null || p_umaScopeDns.isEmpty()) {
                throw new IllegalArgumentException("Scopes can't be empty");
            }
            return this.ldapEntryManager.findEntries(PolicyService.baseDn(), UmaPolicy.class, Filter.create((String)PolicyService.buildScopesFilter(p_umaScopeDns)));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return Collections.emptyList();
        }
    }

    public void persist(UmaPolicy p_policy) {
        try {
            if (StringUtils.isBlank((String)p_policy.getDn())) {
                p_policy.setDn(String.format("inum=%s,", p_policy.getInum()) + PolicyService.baseDn());
            }
            this.ldapEntryManager.persist((Object)p_policy);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private static String buildScopesFilter(List<String> p_umaScopes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(|");
        for (String scope : p_umaScopes) {
            sb.append(String.format("(oxAuthUmaScope=%s)", scope));
        }
        sb.append(")");
        return sb.toString();
    }

    private static String baseDn() {
        return ConfigurationFactory.getBaseDn().getUmaPolicy();
    }

    public static PolicyService instance() {
        return (PolicyService)ServerUtil.instance(PolicyService.class);
    }
}

