/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.status.ldap;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;

@Name(value="ldapStatusTimer")
@AutoCreate
@Scope(value=ScopeType.APPLICATION)
public class LdapStatusTimer {
    private static final String EVENT_TYPE = "LdapStatusTimerEvent";
    private static final long DEFAULT_INTERVAL = 60000L;
    @Logger
    private Log log;
    private AtomicBoolean isActive;

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void init() {
        this.log.debug((Object)"Initializing LdapStatusTimer", new Object[0]);
        this.isActive = new AtomicBoolean(false);
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(60000L), Long.valueOf(60000L)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"LdapStatusTimerEvent"})
    @Asynchronous
    public void process() {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processInt();
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void processInt() {
        this.logConnectionProviderStatistic("centralConnectionProvider", "bindCentralConnectionProvider");
        this.logConnectionProviderStatistic("authConnectionProvider", "bindAuthConnectionProvider");
    }

    public void logConnectionProviderStatistic(String connectionProvider, String bindConnectionProvider) {
        LDAPConnectionProvider ldapConnectionProvider = (LDAPConnectionProvider)Contexts.getApplicationContext().get(connectionProvider);
        LDAPConnectionProvider bindLdapConnectionProvider = (LDAPConnectionProvider)Contexts.getApplicationContext().get(bindConnectionProvider);
        if (ldapConnectionProvider == null) {
            this.log.error((Object)"{0} is empty", new Object[]{connectionProvider});
        } else if (ldapConnectionProvider.getConnectionPool() == null) {
            this.log.error((Object)"{0} is empty", new Object[]{connectionProvider});
        } else {
            this.log.debug((Object)"{0} statistics: {1}", new Object[]{connectionProvider, ldapConnectionProvider.getConnectionPool().getConnectionPoolStatistics()});
        }
        if (bindLdapConnectionProvider == null) {
            this.log.error((Object)"{0} is empty", new Object[]{bindConnectionProvider});
        } else if (bindLdapConnectionProvider.getConnectionPool() == null) {
            this.log.error((Object)"{0} is empty", new Object[]{bindConnectionProvider});
        } else {
            this.log.debug((Object)"{0} statistics: {1}", new Object[]{bindConnectionProvider, bindLdapConnectionProvider.getConnectionPool().getConnectionPoolStatistics()});
        }
    }
}

