/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.StaticUtils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.util.Util;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="sessionIdService")
@AutoCreate
public class SessionIdService {
    private static final String SESSION_ID_COOKIE_NAME = "session_id";
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    public static SessionIdService instance() {
        if (!Contexts.isEventContextActive() && !Contexts.isApplicationContextActive()) {
            Lifecycle.beginCall();
        }
        return (SessionIdService)Component.getInstance(SessionIdService.class);
    }

    public String getSessionIdFromCookie(HttpServletRequest request) {
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(SESSION_ID_COOKIE_NAME)) continue;
                    this.log.trace((Object)"Found session_id cookie: {0}", new Object[]{cookie.getValue()});
                    return cookie.getValue();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return "";
    }

    public void createSessionIdCookie(String sessionId) {
        try {
            Object response = FacesContext.getCurrentInstance().getExternalContext().getResponse();
            if (response instanceof HttpServletResponse) {
                Cookie sessionIdCookie = new Cookie(SESSION_ID_COOKIE_NAME, sessionId);
                sessionIdCookie.setPath("/");
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.addCookie(sessionIdCookie);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void removeSessionIdCookie() {
        try {
            Object response;
            FacesContext currentInstance = FacesContext.getCurrentInstance();
            if (currentInstance != null && currentInstance.getExternalContext() != null && (response = currentInstance.getExternalContext().getResponse()) instanceof HttpServletResponse) {
                this.removeSessionIdCookie((HttpServletResponse)response);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void removeSessionIdCookie(HttpServletResponse httpResponse) {
        Cookie cookie = new Cookie(SESSION_ID_COOKIE_NAME, null);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        httpResponse.addCookie(cookie);
    }

    public String generateId(String p_userDn) {
        SessionId id = this.generateSessionId(p_userDn);
        if (id != null) {
            return id.getId();
        }
        return "";
    }

    public SessionId generateSessionId(String p_userDn) {
        try {
            String uuid = UUID.randomUUID().toString();
            String dn = SessionIdService.dn(uuid);
            if (Util.allNotBlank((String[])new String[]{p_userDn, dn})) {
                SessionId sessionId = new SessionId();
                sessionId.setId(uuid);
                sessionId.setDn(dn);
                sessionId.setLastUsedAt(new Date());
                sessionId.setUserDn(p_userDn);
                FacesContext facesContext = FacesContext.getCurrentInstance();
                if (facesContext != null) {
                    Cookie cookie = new Cookie("opbs", uuid);
                    cookie.setMaxAge(ConfigurationFactory.getConfiguration().getSessionIdUnusedLifetime());
                    ((HttpServletResponse)facesContext.getExternalContext().getResponse()).addCookie(cookie);
                }
                this.ldapEntryManager.persist((Object)sessionId);
                this.log.trace((Object)"Generated new session, id = {0}", new Object[]{sessionId.getId()});
                return sessionId;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }

    private static String dn(String p_id) {
        String baseDn = SessionIdService.getBaseDn();
        StringBuilder sb = new StringBuilder();
        if (Util.allNotBlank((String[])new String[]{p_id, SessionIdService.getBaseDn()})) {
            sb.append("uniqueIdentifier=").append(p_id).append(",").append(baseDn);
        }
        return sb.toString();
    }

    public SessionId getSessionByDN(String p_dn) {
        try {
            return (SessionId)this.ldapEntryManager.find(SessionId.class, (Object)p_dn);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    public SessionId getSessionId(String sessionId) {
        if (StringHelper.isEmpty((String)sessionId)) {
            return null;
        }
        try {
            this.log.trace((Object)"Try to get session by id: {0} ...", new Object[]{sessionId});
            List entries = this.ldapEntryManager.findEntries(SessionIdService.getBaseDn(), SessionId.class, Filter.create((String)String.format("uniqueIdentifier=%s", sessionId)));
            if (entries != null && !entries.isEmpty()) {
                SessionId entity = (SessionId)entries.get(0);
                this.log.trace((Object)"Session dn: {0}", new Object[]{entity.getDn()});
                if (this.isSessionValid(entity)) {
                    return entity;
                }
            }
        }
        catch (LDAPException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        this.log.trace((Object)"Failed to get session by id: {0}", new Object[]{sessionId});
        return null;
    }

    private static String getBaseDn() {
        return ConfigurationFactory.getBaseDn().getSessionId();
    }

    public boolean remove(SessionId p_sessionId) {
        try {
            this.ldapEntryManager.remove((Object)p_sessionId);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return false;
        }
        return true;
    }

    public void updateSessionWithLastUsedDate(SessionId p_sessionId) {
        try {
            Date newDate = new Date();
            p_sessionId.setLastUsedAt(newDate);
            this.ldapEntryManager.merge((Object)p_sessionId);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void cleanUpSessions() {
        int interval = ConfigurationFactory.getConfiguration().getSessionIdUnusedLifetime();
        List<SessionId> list = this.getIdsOlderThan(interval);
        if (list != null && !list.isEmpty()) {
            for (SessionId id : list) {
                this.remove(id);
            }
        }
    }

    public List<SessionId> getIdsOlderThan(int p_intervalInSeconds) {
        try {
            long dateInPast = new Date().getTime() - TimeUnit.SECONDS.toMillis(p_intervalInSeconds);
            Filter filter = Filter.create((String)String.format("(lastModifiedTime<=%s)", StaticUtils.encodeGeneralizedTime((Date)new Date(dateInPast))));
            return this.ldapEntryManager.findEntries(SessionIdService.getBaseDn(), SessionId.class, filter);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return Collections.emptyList();
        }
    }

    public boolean isSessionValid(SessionId sessionId) {
        if (sessionId == null) {
            return false;
        }
        int interval = ConfigurationFactory.getConfiguration().getSessionIdUnusedLifetime();
        long sessionInterval = TimeUnit.SECONDS.toMillis(interval);
        long timeSinceLastAccess = System.currentTimeMillis() - sessionId.getLastUsedAt().getTime();
        return timeSinceLastAccess <= sessionInterval;
    }
}

