/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import java.util.ArrayList;
import java.util.List;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.config.ConfigurationFactory;

@org.jboss.seam.annotations.Scope(value=ScopeType.STATELESS)
@Name(value="scopeService")
@AutoCreate
public class ScopeService {
    @In
    LdapEntryManager ldapEntryManager;
    @Logger
    private Log log;

    public static ScopeService instance() {
        boolean createContexts;
        boolean bl = createContexts = !Contexts.isEventContextActive() && !Contexts.isApplicationContextActive();
        if (createContexts) {
            Lifecycle.beginCall();
        }
        return (ScopeService)Component.getInstance(ScopeService.class);
    }

    public List<Scope> getAllScopesList() {
        String scopesBaseDN = ConfigurationFactory.getBaseDn().getScopes();
        return this.ldapEntryManager.findEntries(scopesBaseDN, Scope.class, Filter.createPresenceFilter((String)"inum"));
    }

    public List<String> getDefaultScopesDn() {
        ArrayList<String> defaultScopes = new ArrayList<String>();
        for (Scope scope : this.getAllScopesList()) {
            if (!scope.getIsDefault()) continue;
            defaultScopes.add(scope.getDn());
        }
        return defaultScopes;
    }

    public List<String> getScopesDn(List<String> scopeNames) {
        ArrayList<String> scopes = new ArrayList<String>();
        for (String scopeName : scopeNames) {
            Scope scope = this.getScopeByDisplayName(scopeName);
            if (scope == null) continue;
            scopes.add(scope.getDn());
        }
        return scopes;
    }

    public Scope getScopeByDn(String dn) {
        return (Scope)this.ldapEntryManager.find(Scope.class, (Object)dn);
    }

    public Scope getScopeByDnSilently(String dn) {
        try {
            return this.getScopeByDn(dn);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    public Scope getScopeByDisplayName(String DisplayName) {
        String scopesBaseDN = ConfigurationFactory.getBaseDn().getScopes();
        Scope scope = new Scope();
        scope.setDn(scopesBaseDN);
        scope.setDisplayName(DisplayName);
        List scopes = this.ldapEntryManager.findEntries((Object)scope);
        if (scopes != null && scopes.size() > 0) {
            return (Scope)scopes.get(0);
        }
        return null;
    }
}

