/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.net.ConnectException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.ClientService;

@Name(value="redirectionUriService")
@Scope(value=ScopeType.STATELESS)
@AutoCreate
public class RedirectionUriService {
    @Logger
    private Log log;
    @In
    private ClientService clientService;

    public String validateRedirectionUri(String clientIdentifier, String completeUri) {
        try {
            Client client = this.clientService.getClient(clientIdentifier);
            if (client != null) {
                String sectorIdentifierUri = client.getSectorIdentifierUri();
                String[] redirectUris = client.getRedirectUris();
                if (StringUtils.isNotBlank((String)sectorIdentifierUri)) {
                    ClientRequest clientRequest = new ClientRequest(sectorIdentifierUri);
                    clientRequest.setHttpMethod("GET");
                    ClientResponse clientResponse = clientRequest.get(String.class);
                    int status = clientResponse.getStatus();
                    if (status == 200) {
                        String entity = (String)clientResponse.getEntity(String.class);
                        JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
                        redirectUris = new String[sectorIdentifierJsonArray.length()];
                        for (int i = 0; i < sectorIdentifierJsonArray.length(); ++i) {
                            redirectUris[i] = sectorIdentifierJsonArray.getString(i);
                        }
                    } else {
                        return null;
                    }
                }
                if (StringUtils.isNotBlank((String)completeUri)) {
                    String oldCompleteUri = completeUri;
                    String redirectionUri = this.removeParams(completeUri);
                    this.log.debug((Object)"Validating redirection URI: clientIdentifier = {0}, oldCompleteUri = {1} => redirectionUri = {2}, found = {3}", new Object[]{clientIdentifier, oldCompleteUri, redirectionUri, redirectUris.length});
                    for (String uri : redirectUris) {
                        this.log.debug((Object)"Comparing {0} == {1}?", new Object[]{uri, redirectionUri});
                        if ((!this.removeParams(uri).equals(redirectionUri) || this.getParams(uri).size() != 0) && (!this.removeParams(uri).equals(redirectionUri) || this.getParams(uri).size() <= 0 || !this.compareParams(completeUri, uri))) continue;
                        return completeUri;
                    }
                } else if (redirectUris != null && redirectUris.length == 1) {
                    return redirectUris[0];
                }
            }
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (UnknownHostException e) {
            return null;
        }
        catch (ConnectException e) {
            return null;
        }
        catch (JSONException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public String validatePostLogoutRedirectUri(String clientId, String postLogoutRedirectUri) {
        Client client = this.clientService.getClient(clientId);
        if (client != null) {
            String[] postLogoutRedirectUris = client.getPostLogoutRedirectUris();
            if (postLogoutRedirectUris != null & StringUtils.isNotBlank((String)postLogoutRedirectUri)) {
                this.log.debug((Object)"Validating post logout redirect URI: clientId = {0}, postLogoutRedirectUri = {1}", new Object[]{clientId, postLogoutRedirectUri});
                for (String uri : postLogoutRedirectUris) {
                    this.log.debug((Object)"Comparing {0} == {1}?", new Object[]{uri, postLogoutRedirectUri});
                    if (!uri.equals(postLogoutRedirectUri)) continue;
                    return postLogoutRedirectUri;
                }
            } else if (postLogoutRedirectUris != null && postLogoutRedirectUris.length == 1) {
                return postLogoutRedirectUris[0];
            }
        }
        return null;
    }

    private String removeParams(String uri) {
        int paramsIndex;
        if (uri != null && (paramsIndex = uri.indexOf("?")) != -1) {
            return uri.substring(0, paramsIndex);
        }
        return uri;
    }

    private Map<String, String> getParams(String uri) {
        int paramsIndex;
        Map<String, String> params = new HashMap<String, String>();
        if (uri != null && (paramsIndex = uri.indexOf("?")) != -1) {
            String queryString = uri.substring(paramsIndex + 1);
            params = QueryStringDecoder.decode((String)queryString);
        }
        return params;
    }

    private boolean compareParams(String uri1, String uri2) {
        if (StringUtils.isBlank((String)uri1) || StringUtils.isBlank((String)uri2)) {
            return false;
        }
        Map<String, String> params1 = this.getParams(uri1);
        Map<String, String> params2 = this.getParams(uri2);
        return ((Object)params1).equals(params2);
    }
}

