/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.federation.FederationRequest;
import org.xdi.oxauth.model.federation.FederationScopePolicy;
import org.xdi.oxauth.model.federation.FederationSkipPolicy;
import org.xdi.oxauth.model.federation.FederationTrust;
import org.xdi.oxauth.model.federation.FederationTrustStatus;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.util.Pair;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.InumService;
import org.xdi.oxauth.util.ServerUtil;

@Scope(value=ScopeType.STATELESS)
@Name(value="federationDataService")
@AutoCreate
public class FederationDataService {
    @Logger
    private Log log;
    @In
    private InumService inumService;
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private ClientService clientService;

    private Pair<String, String> generateNewDN() {
        return this.inumService.generateNewDN(ConfigurationFactory.getBaseDn().getFederationRequest());
    }

    public boolean persist(FederationRequest p_federationRequest) {
        if (p_federationRequest != null && StringUtils.isNotBlank((String)p_federationRequest.getFederationId())) {
            try {
                Pair<String, String> dn = this.generateNewDN();
                p_federationRequest.setDn((String)dn.getSecond());
                p_federationRequest.setId((String)dn.getFirst());
                this.ldapEntryManager.persist((Object)p_federationRequest);
                return true;
            }
            catch (Exception e) {
                this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        return false;
    }

    public static FederationDataService instance() {
        if (!Contexts.isEventContextActive() && !Contexts.isApplicationContextActive()) {
            Lifecycle.beginCall();
        }
        return (FederationDataService)ServerUtil.instance(FederationDataService.class);
    }

    public static boolean skipAuthorization(List<FederationTrust> p_list) {
        FederationSkipPolicy skipPolicy;
        if (p_list != null && !p_list.isEmpty() && (skipPolicy = FederationSkipPolicy.fromStringWithDefault((String)ConfigurationFactory.getConfiguration().getFederationSkipPolicy())) != null) {
            switch (skipPolicy) {
                case OR: {
                    for (FederationTrust t : p_list) {
                        if (!Boolean.TRUE.equals(t.getSkipAuthorization())) continue;
                        return true;
                    }
                    break;
                }
                case AND: {
                    for (FederationTrust t : p_list) {
                        if (Boolean.TRUE.equals(t.getSkipAuthorization())) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static List<String> getScopes(List<FederationTrust> p_list) {
        FederationScopePolicy policy;
        ArrayList<String> result = new ArrayList<String>();
        if (p_list != null && !p_list.isEmpty() && (policy = FederationScopePolicy.fromStringWithDefault((String)ConfigurationFactory.getConfiguration().getFederationScopePolicy())) != null) {
            switch (policy) {
                case JOIN: {
                    for (FederationTrust t : p_list) {
                        if (t.getScopes() == null || t.getScopes().isEmpty()) continue;
                        result.addAll(t.getScopes());
                    }
                    break;
                }
            }
        }
        return result;
    }

    public boolean hasAnyActiveTrust(String clientId) {
        Client client;
        if (StringUtils.isNotBlank((String)clientId) && (client = this.clientService.getClient(clientId)) != null) {
            return this.hasAnyActiveTrust(client);
        }
        return false;
    }

    public boolean hasAnyActiveTrust(Client p_client) {
        List<FederationTrust> list = this.getTrustByClient(p_client, FederationTrustStatus.ACTIVE);
        return list != null && !list.isEmpty();
    }

    public List<FederationTrust> getTrustByClient(Client p_client, FederationTrustStatus p_status) {
        List<FederationTrust> list;
        Object[] redirectUris;
        ArrayList<FederationTrust> result = new ArrayList<FederationTrust>();
        if (p_client != null && p_status != null && !ArrayUtils.isEmpty((Object[])(redirectUris = p_client.getRedirectUris())) && (list = this.getTrustByAnyRedirectUri(Arrays.asList(redirectUris), p_status)) != null && !list.isEmpty()) {
            String uri = p_client.getFederationURI();
            String id = p_client.getFederationId();
            if (StringUtils.isNotBlank((String)uri)) {
                if (StringUtils.isNotBlank((String)id)) {
                    for (FederationTrust t : list) {
                        if (!id.equalsIgnoreCase(t.getFederationId()) || !uri.equalsIgnoreCase(t.getFederationMetadataUri())) continue;
                        result.add(t);
                    }
                } else {
                    for (FederationTrust t : list) {
                        if (!uri.equalsIgnoreCase(t.getFederationMetadataUri())) continue;
                        result.add(t);
                    }
                }
            } else {
                result.addAll(list);
            }
        }
        return result;
    }

    public List<FederationTrust> getTrustByAnyRedirectUri(List<String> p_redirectUri, FederationTrustStatus p_status) {
        if (p_redirectUri != null && !p_redirectUri.isEmpty()) {
            String baseDn = ConfigurationFactory.getBaseDn().getFederationTrust();
            try {
                Filter filter = p_status == null ? Filter.create((String)FederationDataService.createFilter(p_redirectUri)) : Filter.create((String)String.format("&(%s)(oxAuthFederationTrustStatus=%s)", FederationDataService.createFilter(p_redirectUri), p_status.getValue()));
                List result = this.ldapEntryManager.findEntries(baseDn, FederationTrust.class, filter, 100);
                if (result != null) {
                    return result;
                }
            }
            catch (LDAPException e) {
                this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        return Collections.emptyList();
    }

    public static String createFilter(List<String> p_redirectUriList) {
        StringBuilder sb = new StringBuilder("|");
        if (p_redirectUriList != null && !p_redirectUriList.isEmpty()) {
            for (String uri : p_redirectUriList) {
                if (!StringUtils.isNotBlank((String)uri)) continue;
                sb.append(String.format("(oxAuthRedirectURI=%s)", uri));
            }
        }
        return sb.toString();
    }
}

