/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.ConfigurationFactory;

@Name(value="configurationUpdateTimer")
@AutoCreate
@Scope(value=ScopeType.APPLICATION)
public class ConfigurationUpdateTimer {
    private static final String EVENT_TYPE = "ConfigurationUpdateTimerEvent";
    private static final long DEFAULT_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    @Logger
    private Log log;
    private AtomicBoolean isActive;

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void init() {
        this.isActive = new AtomicBoolean(false);
        long interval = ConfigurationFactory.getConfiguration().getConfigurationUpdateInterval();
        if (interval <= 0L) {
            interval = DEFAULT_INTERVAL;
        }
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(interval *= 1000L), Long.valueOf(interval)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"ConfigurationUpdateTimerEvent"})
    @Asynchronous
    public void process() {
        if (this.isActive.get()) {
            return;
        }
        if (this.isActive.compareAndSet(false, true)) {
            try {
                if (ConfigurationFactory.updateFromLdap()) {
                    this.log.trace((Object)"Configuration updated from LDAP successfully.", new Object[0]);
                } else {
                    this.log.trace((Object)"Failed to update configuration from LDAP successfully.", new Object[0]);
                }
            }
            finally {
                this.isActive.set(false);
            }
        }
    }
}

