/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.hibernate.annotations.common.util.StringHelper;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.ldap.model.CustomEntry;
import org.xdi.ldap.model.GluuStatus;
import org.xdi.model.SimpleProperty;
import org.xdi.model.ldap.GluuLdapConfiguration;
import org.xdi.oxauth.authorize.ws.rs.AuthorizeAction;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.SimpleUser;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.session.OAuthCredentials;
import org.xdi.oxauth.service.SessionIdService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.util.ServerUtil;

@Scope(value=ScopeType.STATELESS)
@Name(value="authenticationService")
@AutoCreate
public class AuthenticationService {
    private static final String STORED_REQUEST_PARAMETERS = "stored_request_parameters";
    @Logger
    private Log log;
    @In
    private Identity identity;
    @In
    private OAuthCredentials credentials;
    @In(required=false, value="ldapAuthConfig")
    private GluuLdapConfiguration ldapAuthConfig;
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private LdapEntryManager ldapAuthEntryManager;
    @In
    private UserService userService;
    @In
    private SessionIdService sessionIdService;

    public boolean authenticate(String userName, String password) {
        this.log.debug((Object)"Authenticating user with LDAP: username: {0}", new Object[]{userName});
        if (this.ldapAuthConfig == null) {
            User user = this.userService.getUser(userName);
            if (user != null) {
                if (!this.checkUserStatus(user)) {
                    return false;
                }
                boolean authenticated = this.ldapAuthEntryManager.authenticate(user.getDn(), password);
                if (authenticated) {
                    this.credentials.setUser(user);
                    this.updateLastLogonUserTime(user);
                }
                return authenticated;
            }
        } else {
            String primaryKey = "uid";
            if (StringHelper.isNotEmpty((String)this.ldapAuthConfig.getPrimaryKey())) {
                primaryKey = this.ldapAuthConfig.getPrimaryKey();
            }
            String localPrimaryKey = "uid";
            if (StringHelper.isNotEmpty((String)this.ldapAuthConfig.getLocalPrimaryKey())) {
                localPrimaryKey = this.ldapAuthConfig.getLocalPrimaryKey();
            }
            return this.authenticate(userName, password, primaryKey, localPrimaryKey);
        }
        return false;
    }

    public boolean authenticate(String keyValue, String password, String primaryKey, String localPrimaryKey) {
        this.log.debug((Object)"Attempting to find userDN by primary key: '{0}' and key value: '{1}'", new Object[]{primaryKey, keyValue});
        List<SimpleProperty> baseDNs = this.ldapAuthConfig == null ? Arrays.asList(new SimpleProperty(this.userService.getDnForUser(null))) : this.ldapAuthConfig.getBaseDNs();
        if (baseDNs != null && !baseDNs.isEmpty()) {
            for (SimpleProperty baseDnProperty : baseDNs) {
                String baseDn = baseDnProperty.getValue();
                User user = this.getUserByAttribute(baseDn, primaryKey, keyValue);
                if (user == null) continue;
                String userDn = user.getDn();
                this.log.debug((Object)"Attempting to authenticate userDN: {0}", new Object[]{userDn});
                if (!this.ldapAuthEntryManager.authenticate(userDn, password)) continue;
                this.log.debug((Object)"User authenticated: {0}", new Object[]{userDn});
                this.log.debug((Object)"Attempting to find userDN by local primary key: {0}", new Object[]{localPrimaryKey});
                User localUser = this.userService.getUserByAttribute(localPrimaryKey, keyValue);
                if (localUser == null) continue;
                if (!this.checkUserStatus(localUser)) {
                    return false;
                }
                this.credentials.setUser(localUser);
                this.updateLastLogonUserTime(localUser);
                return true;
            }
        } else {
            this.log.error((Object)"There are no baseDns specified in authentication configuration.", new Object[0]);
        }
        return false;
    }

    public boolean authenticate(String userName) {
        this.log.debug((Object)"Authenticating user with LDAP: username: {0}", new Object[]{userName});
        User user = this.userService.getUser(userName);
        if (user != null) {
            if (!this.checkUserStatus(user)) {
                return false;
            }
            this.credentials.setUsername(user.getUserId());
            this.credentials.setUser(user);
            this.updateLastLogonUserTime(user);
            return true;
        }
        return false;
    }

    public User getUserByAttribute(String baseDn, String attributeName, String attributeValue) {
        this.log.debug((Object)"Getting user information from LDAP: attributeName = '{0}', attributeValue = '{1}'", new Object[]{attributeName, attributeValue});
        SimpleUser sampleUser = new SimpleUser();
        sampleUser.setDn(baseDn);
        ArrayList<org.xdi.oxauth.model.common.CustomAttribute> customAttributes = new ArrayList<org.xdi.oxauth.model.common.CustomAttribute>();
        customAttributes.add(new org.xdi.oxauth.model.common.CustomAttribute(attributeName, attributeValue));
        sampleUser.setCustomAttributes(customAttributes);
        List entries = this.ldapAuthEntryManager.findEntries((Object)sampleUser, 1);
        this.log.debug((Object)"Found '{0}' entries", new Object[]{entries.size()});
        if (entries.size() > 0) {
            SimpleUser foundUser = (SimpleUser)entries.get(0);
            return (User)this.ldapAuthEntryManager.find(User.class, (Object)foundUser.getDn());
        }
        return null;
    }

    private boolean checkUserStatus(User user) {
        org.xdi.oxauth.model.common.CustomAttribute userStatus = this.userService.getCustomAttribute(user, "gluuStatus");
        if (GluuStatus.INACTIVE.equals((Object)GluuStatus.getByValue((String)userStatus.getValue()))) {
            this.log.warn((Object)"User '{0}' was disabled", new Object[]{user.getUserId()});
            return false;
        }
        return true;
    }

    private void updateLastLogonUserTime(User user) {
        CustomEntry customEntry = new CustomEntry();
        customEntry.setDn(user.getDn());
        CustomAttribute customAttribute = new CustomAttribute("oxLastLogonTime", new Date());
        customEntry.getCustomAttributes().add(customAttribute);
        try {
            this.ldapEntryManager.merge((Object)customEntry);
        }
        catch (EntryPersistenceException epe) {
            this.log.error((Object)"Failed to update oxLastLoginTime of user '{0}'", new Object[]{user.getUserId()});
        }
    }

    public String parametersAsString() throws UnsupportedEncodingException {
        Map<String, String> parameterMap = this.getParametersMap(null);
        return this.parametersAsString(parameterMap);
    }

    public String parametersAsString(Map<String, String> parameterMap) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> set = parameterMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String value = entry.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            sb.append(entry.getKey()).append("=").append(URLEncoder.encode(value, "UTF-8")).append("&");
        }
        String result = sb.toString();
        if (result.endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public Map<String, String> getParametersMap(List<String> extraParameters) {
        HashMap<String, String> parameterMap = new HashMap<String, String>(FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap());
        return this.getParametersMap(extraParameters, parameterMap);
    }

    public Map<String, String> getParametersMap(List<String> extraParameters, Map<String, String> parameterMap) {
        ArrayList<String> allowedParameters = new ArrayList<String>(AuthorizeAction.ALLOWED_PARAMETER);
        allowedParameters.addAll(Arrays.asList("auth_mode", "auth_level", "auth_step"));
        AuthenticationService.putInMap(parameterMap, "auth_mode");
        AuthenticationService.putInMap(parameterMap, "auth_level");
        AuthenticationService.putInMap(parameterMap, "auth_step");
        if (extraParameters != null) {
            for (String extraParameter : extraParameters) {
                AuthenticationService.putInMap(parameterMap, extraParameter);
            }
            allowedParameters.addAll(extraParameters);
        }
        Iterator<Map.Entry<String, String>> it = parameterMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (allowedParameters.contains(entry.getKey())) continue;
            it.remove();
        }
        return parameterMap;
    }

    private static void putInMap(Map<String, String> map, String p_name) {
        if (map == null) {
            return;
        }
        Object o = Contexts.getEventContext().get(p_name);
        if (o instanceof String) {
            String s = (String)o;
            map.put(p_name, s);
        } else if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            map.put(p_name, b.toString());
        }
    }

    public void configureEventUser() {
        User user = this.credentials.getUser();
        if (user != null) {
            this.configureEventUser(user);
        }
    }

    public void configureEventUser(User user) {
        SessionId sessionId = this.sessionIdService.generateSessionId(user.getDn());
        sessionId.setAuthenticationTime(new Date());
        this.configureEventUser(sessionId);
    }

    public void configureEventUser(SessionId sessionId) {
        this.identity.addRole("user");
        this.sessionIdService.updateSessionWithLastUsedDate(sessionId);
        Contexts.getEventContext().set("sessionUser", (Object)sessionId);
    }

    public void storeRequestParametersInSession() {
        Contexts.getSessionContext().set(STORED_REQUEST_PARAMETERS, this.getParametersMap(null));
    }

    public Map<String, String> restoreRequestParametersFromSession() {
        Context eventContext = Contexts.getEventContext();
        Context sessionContext = Contexts.getSessionContext();
        if (sessionContext.isSet(STORED_REQUEST_PARAMETERS)) {
            Map storedRequestParameters = (Map)sessionContext.get(STORED_REQUEST_PARAMETERS);
            sessionContext.remove(STORED_REQUEST_PARAMETERS);
            eventContext.set(STORED_REQUEST_PARAMETERS, (Object)storedRequestParameters);
            return storedRequestParameters;
        }
        return null;
    }

    public static AuthenticationService instance() {
        return (AuthenticationService)ServerUtil.instance(AuthenticationService.class);
    }
}

