/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.ResultCode;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration.ConfigurationException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.codehaus.jackson.map.ObjectMapper;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.OperationsFacade;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.LdapMappingException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.xdi.model.SimpleProperty;
import org.xdi.model.SmtpConfiguration;
import org.xdi.model.ldap.GluuLdapConfiguration;
import org.xdi.oxauth.model.appliance.GluuAppliance;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.config.oxIDPAuthConf;
import org.xdi.oxauth.service.ApplianceService;
import org.xdi.oxauth.util.FileConfiguration;
import org.xdi.service.PythonService;
import org.xdi.service.ldap.LdapConnectionService;
import org.xdi.util.StringHelper;
import org.xdi.util.security.PropertiesDecrypter;
import org.xdi.util.security.StringEncrypter;

@Scope(value=ScopeType.APPLICATION)
@Name(value="appInitializer")
@Startup
public class AppInitializer {
    private static final String EVENT_TYPE = "AppInitializerTimerEvent";
    private static final int DEFAULT_INTERVAL = 30;
    public static final String LDAP_AUTH_CONFIG_NAME = "ldapAuthConfig";
    public static final String LDAP_ENTRY_MANAGER_NAME = "ldapEntryManager";
    public static final String LDAP_AUTH_ENTRY_MANAGER_NAME = "ldapAuthEntryManager";
    @Logger
    private Log log;
    @In
    private ApplianceService applianceService;
    private AtomicBoolean isActive;
    private long lastFinishedTime;

    @Create
    public void createApplicationComponents() throws ConfigurationException {
        this.createConnectionProvider("centralLdapConfiguration", "centralConnectionProvider", "bindCentralConnectionProvider");
        ConfigurationFactory.create();
        GluuLdapConfiguration ldapAuthConfig = this.loadLdapAuthConfig((LdapEntryManager)Component.getInstance((String)LDAP_ENTRY_MANAGER_NAME, (boolean)true));
        this.reloadConfigurationImpl(ldapAuthConfig);
        this.createAuthConnectionProvider(ldapAuthConfig, "authConnectionProvider", "bindAuthConnectionProvider");
        this.addSecurityProviders();
        PythonService.instance().initPythonInterpreter();
    }

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void initReloadTimer() {
        this.isActive = new AtomicBoolean(false);
        this.lastFinishedTime = System.currentTimeMillis();
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(60000L), Long.valueOf(30000L)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"AppInitializerTimerEvent"})
    @Asynchronous
    public void reloadConfigurationTimerEvent() {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Throwable ex) {
            this.log.error((Object)"Exception happened while reloading application configuration", ex, new Object[0]);
        }
        finally {
            this.isActive.set(false);
            this.lastFinishedTime = System.currentTimeMillis();
        }
    }

    private void reloadConfiguration() {
        GluuLdapConfiguration newLdapAuthConfig = this.loadLdapAuthConfig((LdapEntryManager)Component.getInstance((String)LDAP_ENTRY_MANAGER_NAME, (boolean)true));
        this.reloadConfigurationImpl(newLdapAuthConfig);
    }

    private void reloadConfigurationImpl(GluuLdapConfiguration newLdapAuthConfig) {
        Context applicationContext = Contexts.getApplicationContext();
        if (newLdapAuthConfig == null) {
            if (applicationContext.isSet(LDAP_AUTH_CONFIG_NAME)) {
                applicationContext.remove(LDAP_AUTH_CONFIG_NAME);
            }
        } else {
            applicationContext.set(LDAP_AUTH_CONFIG_NAME, (Object)newLdapAuthConfig);
        }
    }

    private void addSecurityProviders() {
        try {
            Provider[] providers = Security.getProviders();
            if (providers != null) {
                boolean hasBC = false;
                for (Provider p : providers) {
                    if (!p.getName().equalsIgnoreCase("BC")) continue;
                    hasBC = true;
                }
                if (!hasBC) {
                    Security.addProvider((Provider)new BouncyCastleProvider());
                }
            }
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Factory(value="ldapEntryManager", scope=ScopeType.APPLICATION, autoCreate=true)
    public LdapEntryManager createLdapEntryManager() {
        LdapEntryManager ldapEntryManager = new LdapEntryManager(new OperationsFacade((LDAPConnectionProvider)this.getConnectionProvider(), (LDAPConnectionProvider)this.getBindConnectionProvider()));
        this.log.debug((Object)"Created {0}: {1}", new Object[]{LDAP_ENTRY_MANAGER_NAME, ldapEntryManager});
        return ldapEntryManager;
    }

    @Factory(value="ldapAuthEntryManager", scope=ScopeType.APPLICATION, autoCreate=true)
    public LdapEntryManager createLdapAuthEntryManager() {
        LdapEntryManager ldapEntryManager = new LdapEntryManager(new OperationsFacade((LDAPConnectionProvider)this.getAuthConnectionProvider(), (LDAPConnectionProvider)this.getBindAuthConnectionProvider()));
        this.log.debug((Object)"Created {0}: {1}", new Object[]{LDAP_AUTH_ENTRY_MANAGER_NAME, ldapEntryManager});
        return ldapEntryManager;
    }

    @Factory(value="smtpConfiguration", scope=ScopeType.APPLICATION, autoCreate=true)
    public SmtpConfiguration createSmtpConfiguration() {
        GluuAppliance appliance = this.applianceService.getAppliance();
        SmtpConfiguration smtpConfiguration = appliance.getSmtpConfiguration();
        if (smtpConfiguration == null) {
            return null;
        }
        String password = smtpConfiguration.getPassword();
        if (StringHelper.isNotEmpty((String)password)) {
            try {
                smtpConfiguration.setPasswordDecrypted(StringEncrypter.defaultInstance().decrypt(password));
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error((Object)"Failed to decript SMTP user password", (Throwable)ex, new Object[0]);
            }
        }
        return smtpConfiguration;
    }

    private LdapConnectionService getAuthConnectionProvider() {
        return (LdapConnectionService)Contexts.getApplicationContext().get("authConnectionProvider");
    }

    private LdapConnectionService getBindAuthConnectionProvider() {
        return (LdapConnectionService)Contexts.getApplicationContext().get("bindAuthConnectionProvider");
    }

    private LdapConnectionService getConnectionProvider() {
        return (LdapConnectionService)Contexts.getApplicationContext().get("centralConnectionProvider");
    }

    private LdapConnectionService getBindConnectionProvider() {
        return (LdapConnectionService)Contexts.getApplicationContext().get("bindCentralConnectionProvider");
    }

    private void createConnectionProvider(String configurationComponentName, String connectionProviderComponentName, String bindConnectionProviderComponentName) throws ConfigurationException {
        FileConfiguration configuration = ConfigurationFactory.getLdapConfiguration();
        Contexts.getApplicationContext().set(configurationComponentName, (Object)configuration);
        LdapConnectionService connectionProvider = new LdapConnectionService(PropertiesDecrypter.decryptProperties((Properties)configuration.getProperties()));
        Contexts.getApplicationContext().set(connectionProviderComponentName, (Object)connectionProvider);
        Properties bindProperties = (Properties)configuration.getProperties().clone();
        bindProperties.remove("bindDN");
        bindProperties.remove("bindPassword");
        LdapConnectionService bindCentralConnectionProvider = new LdapConnectionService(PropertiesDecrypter.decryptProperties((Properties)bindProperties));
        Contexts.getApplicationContext().set(bindConnectionProviderComponentName, (Object)bindCentralConnectionProvider);
    }

    private void createAuthConnectionProvider(GluuLdapConfiguration ldapAuthConfig, String connectionProviderComponentName, String bindConnectionProviderComponentName) throws ConfigurationException {
        FileConfiguration configuration = ConfigurationFactory.getLdapConfiguration();
        Properties properties = (Properties)configuration.getProperties().clone();
        if (ldapAuthConfig != null) {
            properties.setProperty("servers", this.buildServersString(ldapAuthConfig.getServers()));
            String bindDn = ldapAuthConfig.getBindDN();
            if (StringHelper.isNotEmpty((String)bindDn)) {
                properties.setProperty("bindDN", ldapAuthConfig.getBindDN());
            }
            properties.setProperty("bindPassword", ldapAuthConfig.getBindPassword());
            properties.setProperty("useSSL", Boolean.toString(ldapAuthConfig.isUseSSL()));
        }
        LdapConnectionService connectionProvider = new LdapConnectionService(PropertiesDecrypter.decryptProperties((Properties)properties));
        Contexts.getApplicationContext().set(connectionProviderComponentName, (Object)connectionProvider);
        Properties bindProperties = (Properties)properties.clone();
        bindProperties.remove("bindDN");
        bindProperties.remove("bindPassword");
        LdapConnectionService bindCentralConnectionProvider = new LdapConnectionService(PropertiesDecrypter.decryptProperties((Properties)bindProperties));
        if (ResultCode.INAPPROPRIATE_AUTHENTICATION.equals((Object)bindCentralConnectionProvider.getCreationResultCode())) {
            this.log.warn((Object)"It's not possible to create authentication LDAP connection pool using anonymous bind. Attempting to create it using binDN/bindPassword", new Object[0]);
            bindCentralConnectionProvider = new LdapConnectionService(PropertiesDecrypter.decryptProperties((Properties)properties));
        }
        Contexts.getApplicationContext().set(bindConnectionProviderComponentName, (Object)bindCentralConnectionProvider);
    }

    private String buildServersString(List<SimpleProperty> servers) {
        StringBuilder sb = new StringBuilder();
        if (servers == null) {
            return sb.toString();
        }
        boolean first = true;
        for (SimpleProperty server : servers) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(server.getValue());
        }
        return sb.toString();
    }

    public oxIDPAuthConf loadLdapIdpAuthConfig(LdapEntryManager localLdapEntryManager) {
        String baseDn = ConfigurationFactory.getBaseDn().getAppliance();
        String applianceInum = ConfigurationFactory.getConfiguration().getApplianceInum();
        if (StringHelper.isEmpty((String)baseDn) || StringHelper.isEmpty((String)applianceInum)) {
            return null;
        }
        String applianceDn = String.format("inum=%s,%s", applianceInum, baseDn);
        GluuAppliance appliance = null;
        try {
            appliance = (GluuAppliance)localLdapEntryManager.find(GluuAppliance.class, (Object)applianceDn);
        }
        catch (LdapMappingException ex) {
            this.log.error((Object)"Failed to load appliance entry from Ldap", (Throwable)ex, new Object[0]);
            return null;
        }
        if (appliance == null || appliance.getOxIDPAuthentication() == null) {
            return null;
        }
        for (String configurationJson : appliance.getOxIDPAuthentication()) {
            oxIDPAuthConf configuration = null;
            try {
                configuration = (oxIDPAuthConf)this.jsonToObject(configurationJson, oxIDPAuthConf.class);
                if (!configuration.getType().equalsIgnoreCase("ldap") && !configuration.getType().equalsIgnoreCase("auth")) continue;
                return configuration;
            }
            catch (Exception ex) {
                this.log.error((Object)"Failed to create object by json: '{0}'", (Throwable)ex, new Object[]{configurationJson});
            }
        }
        return null;
    }

    public GluuLdapConfiguration loadLdapAuthConfig(oxIDPAuthConf configuration) {
        if (configuration == null) {
            return null;
        }
        try {
            if (configuration.getType().equalsIgnoreCase("ldap")) {
                return this.mapOldLdapConfig(configuration);
            }
            if (configuration.getType().equalsIgnoreCase("auth")) {
                return this.mapLdapConfig(configuration.getConfig());
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to create object by oxIDPAuthConf: '{0}'", (Throwable)ex, new Object[]{configuration});
        }
        return null;
    }

    public GluuLdapConfiguration loadLdapAuthConfig(LdapEntryManager localLdapEntryManager) {
        return this.loadLdapAuthConfig(this.loadLdapIdpAuthConfig(localLdapEntryManager));
    }

    @Deprecated
    private GluuLdapConfiguration mapOldLdapConfig(oxIDPAuthConf oneConf) {
        GluuLdapConfiguration ldapConfig = new GluuLdapConfiguration();
        ldapConfig.setServers(Arrays.asList(new SimpleProperty(oneConf.getFields().get(0).getValues().get(0) + ":" + oneConf.getFields().get(1).getValues().get(0))));
        ldapConfig.setBindDN(oneConf.getFields().get(2).getValues().get(0));
        ldapConfig.setBindPassword(oneConf.getFields().get(3).getValues().get(0));
        ldapConfig.setUseSSL(Boolean.valueOf(oneConf.getFields().get(4).getValues().get(0)).booleanValue());
        ldapConfig.setMaxConnections(3);
        ldapConfig.setConfigId("auth_ldap_server");
        ldapConfig.setEnabled(oneConf.getEnabled());
        return ldapConfig;
    }

    private GluuLdapConfiguration mapLdapConfig(String config) throws Exception {
        return (GluuLdapConfiguration)this.jsonToObject(config, GluuLdapConfiguration.class);
    }

    private Object jsonToObject(String json, Class<?> clazz) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Object clazzObject = mapper.readValue(json, clazz);
        return clazzObject;
    }
}

