/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.token;

import java.io.UnsupportedEncodingException;
import java.security.SignatureException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.config.ClaimMappingConfiguration;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.crypto.PublicKey;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.jwe.JweEncrypterImpl;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.model.jws.ECDSASigner;
import org.xdi.oxauth.model.jws.HMACSigner;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.util.security.StringEncrypter;

public class IdTokenFactory {
    public static Jwt generateSignedIdToken(IAuthorizationGrant authorizationGrant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, Map<String, String> claims) throws SignatureException, InvalidJwtException, StringEncrypter.EncryptionException {
        Jwt jwt = new Jwt();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromName((String)ConfigurationFactory.getConfiguration().getDefaultSignatureAlgorithm());
        if (authorizationGrant.getClient() != null && authorizationGrant.getClient().getIdTokenSignedResponseAlg() != null) {
            signatureAlgorithm = SignatureAlgorithm.fromName((String)authorizationGrant.getClient().getIdTokenSignedResponseAlg());
        }
        if (signatureAlgorithm == SignatureAlgorithm.NONE) {
            jwt.getHeader().setType(JwtType.JWT);
        } else {
            jwt.getHeader().setType(JwtType.JWS);
        }
        jwt.getHeader().setAlgorithm(signatureAlgorithm);
        switch (signatureAlgorithm) {
            case RS256: {
                jwt.getHeader().setKeyId(ConfigurationFactory.getConfiguration().getRs256KeyId());
                break;
            }
            case RS384: {
                jwt.getHeader().setKeyId(ConfigurationFactory.getConfiguration().getRs384KeyId());
                break;
            }
            case RS512: {
                jwt.getHeader().setKeyId(ConfigurationFactory.getConfiguration().getRs512KeyId());
                break;
            }
            case ES256: {
                jwt.getHeader().setKeyId(ConfigurationFactory.getConfiguration().getEs256KeyId());
                break;
            }
            case ES384: {
                jwt.getHeader().setKeyId(ConfigurationFactory.getConfiguration().getEs384KeyId());
                break;
            }
            case ES512: {
                jwt.getHeader().setKeyId(ConfigurationFactory.getConfiguration().getEs512KeyId());
                break;
            }
        }
        jwt.getClaims().setIssuer(ConfigurationFactory.getConfiguration().getIssuer());
        jwt.getClaims().setAudience(authorizationGrant.getClient().getClientId());
        int lifeTime = ConfigurationFactory.getConfiguration().getIdTokenLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwt.getClaims().setExpirationTime(expiration);
        jwt.getClaims().setIssuedAt(issuedAt);
        if (authorizationGrant.getUserDn() != null) {
            jwt.getClaims().setClaim("sub", authorizationGrant.getUserId());
            String ldapAttribute = ClaimMappingConfiguration.getClaimByLdap("oxInum");
            jwt.getClaims().setClaim("oxInum", authorizationGrant.getUser().getAttribute(ldapAttribute));
        }
        if (StringUtils.isNotBlank((String)nonce)) {
            jwt.getClaims().setClaim("nonce", nonce);
        }
        if (authorizationGrant.getAuthenticationTime() != null) {
            jwt.getClaims().setClaim("auth_time", authorizationGrant.getAuthenticationTime());
        }
        if (authorizationCode != null) {
            String codeHash = authorizationCode.getHash(signatureAlgorithm);
            jwt.getClaims().setClaim("c_hash", codeHash);
        }
        if (accessToken != null) {
            String accessTokenHash = accessToken.getHash(signatureAlgorithm);
            jwt.getClaims().setClaim("at_hash", accessTokenHash);
        }
        jwt.getClaims().setClaim("oxValidationURI", ConfigurationFactory.getConfiguration().getCheckSessionIFrame());
        jwt.getClaims().setClaim("oxOpenIDConnectVersion", ConfigurationFactory.getConfiguration().getOxOpenIdConnectVersion());
        if (claims != null) {
            for (String key : claims.keySet()) {
                String value = claims.get(key);
                jwt.getClaims().setClaim(key, value);
            }
        }
        JSONWebKeySet jwks = ConfigurationFactory.getWebKeys();
        JSONWebKey jwk = null;
        switch (signatureAlgorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                HMACSigner hmacSigner = new HMACSigner(signatureAlgorithm, authorizationGrant.getClient().getClientSecret());
                jwt = hmacSigner.sign(jwt);
                break;
            }
            case RS256: 
            case RS384: 
            case RS512: {
                jwk = jwks.getKey(jwt.getHeader().getClaimAsString("kid"));
                RSAPrivateKey rsaPrivateKey = new RSAPrivateKey(jwk.getPrivateKey().getModulus(), jwk.getPrivateKey().getPrivateExponent());
                RSASigner rsaSigner = new RSASigner(signatureAlgorithm, rsaPrivateKey);
                jwt = rsaSigner.sign(jwt);
                break;
            }
            case ES256: 
            case ES384: 
            case ES512: {
                jwk = jwks.getKey(jwt.getHeader().getClaimAsString("kid"));
                ECDSAPrivateKey ecdsaPrivateKey = new ECDSAPrivateKey(jwk.getPrivateKey().getD());
                ECDSASigner ecdsaSigner = new ECDSASigner(signatureAlgorithm, ecdsaPrivateKey);
                jwt = ecdsaSigner.sign(jwt);
                break;
            }
            case NONE: {
                break;
            }
        }
        return jwt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Jwe generateEncryptedIdToken(IAuthorizationGrant authorizationGrant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, Map<String, String> claims) throws InvalidJweException {
        JweEncrypterImpl jweEncrypter;
        Jwe jwe = new Jwe();
        KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getIdTokenEncryptedResponseAlg());
        BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getIdTokenEncryptedResponseEnc());
        jwe.getHeader().setType(JwtType.JWE);
        jwe.getHeader().setAlgorithm(keyEncryptionAlgorithm);
        jwe.getHeader().setEncryptionMethod(blockEncryptionAlgorithm);
        jwe.getClaims().setIssuer(ConfigurationFactory.getConfiguration().getIssuer());
        jwe.getClaims().setAudience(authorizationGrant.getClient().getClientId());
        int lifeTime = ConfigurationFactory.getConfiguration().getIdTokenLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwe.getClaims().setExpirationTime(expiration);
        jwe.getClaims().setIssuedAt(issuedAt);
        if (authorizationGrant.getUserDn() != null) {
            jwe.getClaims().setClaim("sub", authorizationGrant.getUserId());
            String ldapAttribute = ClaimMappingConfiguration.getClaimByLdap("oxInum");
            jwe.getClaims().setClaim("oxInum", authorizationGrant.getUser().getAttribute(ldapAttribute));
        }
        if (StringUtils.isNotBlank((String)nonce)) {
            jwe.getClaims().setClaim("nonce", nonce);
        }
        if (authorizationGrant.getAuthenticationTime() != null) {
            jwe.getClaims().setClaim("auth_time", authorizationGrant.getAuthenticationTime());
        }
        if (authorizationCode != null) {
            String codeHash = authorizationCode.getHash(null);
            jwe.getClaims().setClaim("c_hash", codeHash);
        }
        if (accessToken != null) {
            String accessTokenHash = accessToken.getHash(null);
            jwe.getClaims().setClaim("at_hash", accessTokenHash);
        }
        jwe.getClaims().setClaim("oxValidationURI", ConfigurationFactory.getConfiguration().getCheckSessionIFrame());
        jwe.getClaims().setClaim("oxOpenIDConnectVersion", ConfigurationFactory.getConfiguration().getOxOpenIdConnectVersion());
        if (claims != null) {
            for (String key : claims.keySet()) {
                String value = claims.get(key);
                jwe.getClaims().setClaim(key, value);
            }
        }
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
            PublicKey publicKey = JwtUtil.getPublicKey((String)authorizationGrant.getClient().getJwksUri(), (SignatureAlgorithm)SignatureAlgorithm.RS256, null);
            if (publicKey == null) throw new InvalidJweException("The public key is not valid");
            if (!(publicKey instanceof RSAPublicKey)) throw new InvalidJweException("The public key is not valid");
            jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, (RSAPublicKey)publicKey);
            return jweEncrypter.encrypt(jwe);
        }
        if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A128KW) {
            if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A256KW) return jwe;
        }
        try {
            byte[] sharedSymmetricKey = authorizationGrant.getClient().getClientSecret().getBytes("UTF-8");
            jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, sharedSymmetricKey);
            return jweEncrypter.encrypt(jwe);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidJweException((Throwable)e);
        }
    }
}

