/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.config;

import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.xdi.oxauth.model.config.ConfigurationFactory;

@XmlRootElement(name="claim-mapping")
public class ClaimMappingConfiguration {
    @XmlAttribute(name="ldap")
    private String ldap;
    @XmlAttribute(name="claim")
    private String claim;

    public ClaimMappingConfiguration() {
    }

    public ClaimMappingConfiguration(String p_ldap, String p_claim) {
        this.ldap = p_ldap;
        this.claim = p_claim;
    }

    public static List<ClaimMappingConfiguration> liveInstance() {
        return ConfigurationFactory.getClaimMappings();
    }

    public static ClaimMappingConfiguration getMappingByLdap(String p_ldapName) {
        List<ClaimMappingConfiguration> list = ClaimMappingConfiguration.liveInstance();
        if (list != null && !list.isEmpty()) {
            for (ClaimMappingConfiguration m : list) {
                if (!m.getLdap().equals(p_ldapName)) continue;
                return m;
            }
        }
        return null;
    }

    public static ClaimMappingConfiguration getMappingByClaim(String p_claimName) {
        List<ClaimMappingConfiguration> list = ClaimMappingConfiguration.liveInstance();
        if (list != null && !list.isEmpty()) {
            for (ClaimMappingConfiguration m : list) {
                if (!m.getClaim().equals(p_claimName)) continue;
                return m;
            }
        }
        return null;
    }

    public static String getClaimByLdap(String p_ldapName) {
        ClaimMappingConfiguration m = ClaimMappingConfiguration.getMappingByLdap(p_ldapName);
        return m != null ? m.getClaim() : "";
    }

    public String getClaim() {
        return this.claim;
    }

    public void setClaim(String p_claim) {
        this.claim = p_claim;
    }

    public String getLdap() {
        return this.ldap;
    }

    public void setLdap(String p_ldap) {
        this.ldap = p_ldap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClaimMappingConfiguration that = (ClaimMappingConfiguration)o;
        if (this.claim != null ? !this.claim.equals(that.claim) : that.claim != null) {
            return false;
        }
        return !(this.ldap != null ? !this.ldap.equals(that.ldap) : that.ldap != null);
    }

    public int hashCode() {
        int result = this.ldap != null ? this.ldap.hashCode() : 0;
        result = 31 * result + (this.claim != null ? this.claim.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClaimMappingConfiguration");
        sb.append("{claim='").append(this.claim).append('\'');
        sb.append(", ldap='").append(this.ldap).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

