/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class SessionIdAccessMap
implements Serializable {
    @XmlElement(name="map")
    private Map<String, Boolean> permissionGranted;

    public SessionIdAccessMap() {
    }

    public SessionIdAccessMap(Map<String, Boolean> permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    public Map<String, Boolean> getPermissionGranted() {
        return this.permissionGranted;
    }

    public void setPermissionGranted(Map<String, Boolean> permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    public Boolean get(String clientId) {
        this.ensureInitialized();
        Boolean result = this.permissionGranted.get(clientId);
        return result != null ? result : false;
    }

    private void ensureInitialized() {
        if (this.permissionGranted == null) {
            this.permissionGranted = new HashMap<String, Boolean>();
        }
    }

    public void put(String clientId, Boolean granted) {
        this.ensureInitialized();
        this.permissionGranted.put(clientId, granted);
    }
}

