/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.AuthorizationCodeGrant;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantInMemory;
import org.xdi.oxauth.model.common.ClientCredentialsGrant;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.common.IAuthorizationGrantList;
import org.xdi.oxauth.model.common.IdToken;
import org.xdi.oxauth.model.common.ImplicitGrant;
import org.xdi.oxauth.model.common.RefreshToken;
import org.xdi.oxauth.model.common.ResourceOwnerPasswordCredentialsGrant;
import org.xdi.oxauth.model.common.TokenIssuerObserver;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.registration.Client;

public class AuthorizationGrantListInMemory
implements TokenIssuerObserver,
IAuthorizationGrantList {
    private static final Log LOGGER = Logging.getLog(AuthorizationGrantListInMemory.class);
    private Map<String, AuthorizationGrant> authorizationGrantsByCode = new ConcurrentHashMap<String, AuthorizationGrant>();
    private Map<String, AuthorizationGrant> authorizationGrantsByIdToken = new ConcurrentHashMap<String, AuthorizationGrant>();
    private Map<String, AuthorizationGrant> authorizationGrantsByAccessToken = new ConcurrentHashMap<String, AuthorizationGrant>();
    private Map<String, AuthorizationGrant> authorizationGrantsByRefreshToken = new ConcurrentHashMap<String, AuthorizationGrant>();
    private Multimap<String, AuthorizationGrant> authorizationGrantsByClientId = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    @Override
    public List<AuthorizationGrant> getAuthorizationGrants() {
        return new ArrayList<AuthorizationGrant>(this.authorizationGrantsByClientId.values());
    }

    @Override
    public void removeAuthorizationGrants(List<AuthorizationGrant> authorizationGrants) {
        for (AuthorizationGrant authorizationGrant : authorizationGrants) {
            if (authorizationGrant instanceof AuthorizationCodeGrant) {
                AuthorizationCode authorizationCode = ((AuthorizationCodeGrant)authorizationGrant).getAuthorizationCode();
                this.authorizationGrantsByCode.remove(authorizationCode.getCode());
            }
            if (authorizationGrant.getIdToken() != null) {
                this.authorizationGrantsByIdToken.remove(authorizationGrant.getIdToken().getCode());
            }
            for (String code : authorizationGrant.getAccessTokensCodes()) {
                this.authorizationGrantsByAccessToken.remove(code);
            }
            if (authorizationGrant.getLongLivedAccessToken() != null) {
                this.authorizationGrantsByAccessToken.remove(authorizationGrant.getLongLivedAccessToken().getCode());
            }
            for (String code : authorizationGrant.getRefreshTokensCodes()) {
                this.authorizationGrantsByRefreshToken.remove(code);
            }
            if (authorizationGrant.getClient() == null) continue;
            this.authorizationGrantsByClientId.remove((Object)authorizationGrant.getClient().getClientId(), (Object)authorizationGrant);
        }
    }

    @Override
    public void addAuthorizationGrant(AuthorizationGrant authorizationGrant) {
        IAuthorizationGrant grant;
        if (authorizationGrant != null && (grant = authorizationGrant.getGrant()) instanceof AuthorizationGrantInMemory) {
            AuthorizationGrantInMemory inMemory = (AuthorizationGrantInMemory)grant;
            inMemory.setTokenIssuerObserver(this);
            if (authorizationGrant instanceof AuthorizationCodeGrant) {
                AuthorizationCode authorizationCode = authorizationGrant.getAuthorizationCode();
                this.indexByAuthorizationCode(authorizationCode, authorizationGrant);
            }
            if (authorizationGrant.getIdToken() != null) {
                this.indexByIdToken(authorizationGrant.getIdToken(), authorizationGrant);
            }
            for (AccessToken accessToken : authorizationGrant.getAccessTokens()) {
                this.indexByAccessToken(accessToken, authorizationGrant);
            }
            for (RefreshToken refreshToken : authorizationGrant.getRefreshTokens()) {
                this.indexByRefreshToken(refreshToken, authorizationGrant);
            }
            if (authorizationGrant.getClient() != null) {
                this.indexByClient(authorizationGrant.getClient(), authorizationGrant);
            }
        }
    }

    @Override
    public AuthorizationGrant createAuthorizationGrant(User user, Client client, Date authenticationTime) {
        AuthorizationGrant authorizationGrant = new AuthorizationGrant(user, null, client, authenticationTime);
        this.addAuthorizationGrant(authorizationGrant);
        LOGGER.debug((Object)"Created new AuthorizationGrant for User: {0}, Client: {1}", new Object[]{user.getUserId(), authorizationGrant.getClient().getClientId()});
        return authorizationGrant;
    }

    @Override
    public AuthorizationCodeGrant createAuthorizationCodeGrant(User user, Client client, Date authenticationTime) {
        AuthorizationCodeGrant authorizationCodeGrant = new AuthorizationCodeGrant(user, client, authenticationTime);
        this.addAuthorizationGrant(authorizationCodeGrant);
        LOGGER.debug((Object)"Created new AuthorizationCodeGrant for User: {0}, Client: {1} and AuthorizationCode: {2}", new Object[]{user.getUserId(), authorizationCodeGrant.getClient().getClientId(), authorizationCodeGrant.getAuthorizationCode().getCode()});
        return authorizationCodeGrant;
    }

    @Override
    public ImplicitGrant createImplicitGrant(User user, Client client, Date authenticationTime) {
        ImplicitGrant implicitGrant = new ImplicitGrant(user, client, authenticationTime);
        this.addAuthorizationGrant(implicitGrant);
        LOGGER.debug((Object)"Created new ImplicitGrant for User {0} and Client: {1}", new Object[]{user, implicitGrant.getClient().getClientId()});
        return implicitGrant;
    }

    @Override
    public ClientCredentialsGrant createClientCredentialsGrant(User user, Client client) {
        ClientCredentialsGrant clientCredentialsGrant = new ClientCredentialsGrant(user, client);
        this.addAuthorizationGrant(clientCredentialsGrant);
        LOGGER.debug((Object)"Created new ClientCredentialsGrant for User {0} and Client: {1}", new Object[]{user, clientCredentialsGrant.getClient().getClientId()});
        return clientCredentialsGrant;
    }

    @Override
    public ResourceOwnerPasswordCredentialsGrant createResourceOwnerPasswordCredentialsGrant(User user, Client client) {
        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = new ResourceOwnerPasswordCredentialsGrant(user, client);
        this.addAuthorizationGrant(resourceOwnerPasswordCredentialsGrant);
        LOGGER.debug((Object)"Created new ResourceOwnerPasswordCredentialsGrant for User: {0} and Client: {0}", new Object[]{user.getUserId(), client.getClientId()});
        return resourceOwnerPasswordCredentialsGrant;
    }

    @Override
    public AuthorizationCodeGrant getAuthorizationCodeGrant(String clientId, String authorizationCode) {
        AuthorizationCodeGrant authorizationCodeGrant;
        LOGGER.debug((Object)"Looking for an authorization code grant for client: {0} Authorization code: {1}", new Object[]{clientId, authorizationCode});
        AuthorizationGrant authorizationGrant = this.authorizationGrantsByCode.get(authorizationCode);
        if (authorizationGrant != null && authorizationGrant instanceof AuthorizationCodeGrant && (authorizationCodeGrant = (AuthorizationCodeGrant)authorizationGrant).getClient().getClientId().equals(clientId)) {
            if (authorizationCodeGrant.getAuthorizationCode().isValid()) {
                LOGGER.debug((Object)"Authorization code grant found", new Object[0]);
                return authorizationCodeGrant;
            }
            LOGGER.debug((Object)"Revoking all tokens", new Object[0]);
            authorizationCodeGrant.revokeAllTokens();
        }
        LOGGER.debug((Object)"Authorization code grant not found", new Object[0]);
        return null;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByRefreshToken(String clientId, String refreshTokenCode) {
        LOGGER.debug((Object)"Looking for an authorization grant for client: {0} Refresh token: {1}", new Object[]{clientId, refreshTokenCode});
        AuthorizationGrant authorizationGrant = this.authorizationGrantsByRefreshToken.get(refreshTokenCode);
        if (authorizationGrant != null && authorizationGrant.getClient().getClientId().equals(clientId)) {
            RefreshToken refreshToken = authorizationGrant.getRefreshToken(refreshTokenCode);
            if (refreshToken != null && refreshToken.isValid()) {
                LOGGER.debug((Object)"Authorization grant found", new Object[0]);
                return authorizationGrant;
            }
            if (refreshToken != null && refreshToken.isRevoked()) {
                LOGGER.warn((Object)"Attempt to use a revoked refresh token", new Object[0]);
            }
        }
        LOGGER.debug((Object)"Authorization grant not found", new Object[0]);
        return null;
    }

    @Override
    public List<AuthorizationGrant> getAuthorizationGrant(String clientId) {
        LOGGER.debug((Object)"Looking for authorization grants for client: {0}", new Object[]{clientId});
        ArrayList<AuthorizationGrant> authorizationGrantList = new ArrayList<AuthorizationGrant>(this.authorizationGrantsByClientId.get((Object)clientId));
        LOGGER.debug((Object)"Authorization grants found: {0}", new Object[]{authorizationGrantList.size()});
        return authorizationGrantList;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByAccessToken(String tokenCode) {
        AbstractToken token;
        LOGGER.debug((Object)"Looking for an authorization grant for the token: {0}", new Object[]{tokenCode});
        AuthorizationGrant authorizationGrant = this.authorizationGrantsByAccessToken.get(tokenCode);
        if (authorizationGrant != null && (token = authorizationGrant.getAccessToken(tokenCode)) != null && token.isValid()) {
            LOGGER.debug((Object)"Authorization grant found", new Object[0]);
            return authorizationGrant;
        }
        return null;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByIdToken(String idToken) {
        LOGGER.debug((Object)"Looking for an authorization grant fir id token: {0}", new Object[]{idToken});
        AuthorizationGrant authorizationGrant = this.authorizationGrantsByIdToken.get(idToken);
        if (authorizationGrant != null && authorizationGrant.getIdToken() != null && authorizationGrant.getIdToken().isValid()) {
            LOGGER.debug((Object)"Authorization grant found", new Object[0]);
            return authorizationGrant;
        }
        return null;
    }

    @Override
    public synchronized void indexByAuthorizationCode(AuthorizationCode authorizationCode, AuthorizationGrant authorizationGrant) {
        if (authorizationCode != null && authorizationGrant != null) {
            this.authorizationGrantsByCode.put(authorizationCode.getCode(), authorizationGrant);
        }
    }

    @Override
    public synchronized void indexByAccessToken(AccessToken accessToken, AuthorizationGrant authorizationGrant) {
        if (accessToken != null && authorizationGrant != null) {
            this.authorizationGrantsByAccessToken.put(accessToken.getCode(), authorizationGrant);
        }
    }

    @Override
    public synchronized void indexByRefreshToken(RefreshToken refreshToken, AuthorizationGrant authorizationGrant) {
        if (refreshToken != null && authorizationGrant != null) {
            this.authorizationGrantsByRefreshToken.put(refreshToken.getCode(), authorizationGrant);
        }
    }

    @Override
    public synchronized void indexByIdToken(IdToken idToken, AuthorizationGrant authorizationGrant) {
        if (idToken != null && authorizationGrant != null) {
            this.authorizationGrantsByIdToken.put(idToken.getCode(), authorizationGrant);
        }
    }

    @Override
    public synchronized void indexByClient(Client client, AuthorizationGrant authorizationGrant) {
        if (client != null && authorizationGrant != null) {
            this.authorizationGrantsByClientId.put((Object)client.getClientId(), (Object)authorizationGrant);
        }
    }
}

