/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.util.Date;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AuthorizationCodeGrant;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantInMemory;
import org.xdi.oxauth.model.common.AuthorizationGrantListInMemory;
import org.xdi.oxauth.model.common.AuthorizationGrantListLdap;
import org.xdi.oxauth.model.common.ClientCredentialsGrant;
import org.xdi.oxauth.model.common.IAuthorizationGrantList;
import org.xdi.oxauth.model.common.ImplicitGrant;
import org.xdi.oxauth.model.common.ResourceOwnerPasswordCredentialsGrant;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.token.PersistentJwt;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.UserService;

@Name(value="authorizationGrantList")
@Startup(depends={"appInitializer"})
@Scope(value=ScopeType.APPLICATION)
public class AuthorizationGrantList
implements IAuthorizationGrantList {
    @Logger
    private Log log;
    @In
    private UserService userService;
    @In
    private ClientService clientService;
    private IAuthorizationGrantList grant;

    @Create
    public void init() {
        switch (ConfigurationFactory.getConfiguration().getModeEnum()) {
            case IN_MEMORY: {
                this.grant = new AuthorizationGrantListInMemory();
                this.loadPersistentJwts();
                this.log.info((Object)"Created IN-MEMORY authorization grant list", new Object[0]);
                break;
            }
            case LDAP: {
                this.grant = AuthorizationGrantListLdap.instance();
                this.log.info((Object)"Created LDAP authorization grant list", new Object[0]);
                break;
            }
            default: {
                this.log.error((Object)"Unable to identify mode of the server. (Please check configuration.)", new Object[0]);
                throw new IllegalArgumentException("Unable to identify mode of the server. (Please check configuration.)");
            }
        }
    }

    private void loadPersistentJwts() {
        List<User> users = this.userService.getUsersWithPersistentJwts();
        for (User user : users) {
            for (String persistentJwtCode : user.getOxAuthPersistentJwt()) {
                PersistentJwt persistentJwt = new PersistentJwt(persistentJwtCode);
                Client client = this.clientService.getClient(persistentJwt.getClientId());
                Date authenticationTime = persistentJwt.getAuthenticationTime();
                AuthorizationGrant authorizationGrant = null;
                switch (persistentJwt.getAuthorizationGrantType()) {
                    case AUTHORIZATION_CODE: {
                        authorizationGrant = new AuthorizationCodeGrant(user, client, authenticationTime);
                        break;
                    }
                    case IMPLICIT: {
                        authorizationGrant = new ImplicitGrant(user, client, authenticationTime);
                        break;
                    }
                    case RESOURCE_OWNER_PASSWORD_CREDENTIALS: {
                        authorizationGrant = new ResourceOwnerPasswordCredentialsGrant(user, client);
                        if (!(authorizationGrant.getGrant() instanceof AuthorizationGrantInMemory)) break;
                        ((AuthorizationGrantInMemory)authorizationGrant.getGrant()).setAuthenticationTime(authenticationTime);
                        break;
                    }
                    case CLIENT_CREDENTIALS: {
                        authorizationGrant = new ClientCredentialsGrant(user, client);
                        if (!(authorizationGrant.getGrant() instanceof AuthorizationGrantInMemory)) break;
                        ((AuthorizationGrantInMemory)authorizationGrant.getGrant()).setAuthenticationTime(authenticationTime);
                        break;
                    }
                    default: {
                        authorizationGrant = new AuthorizationGrant(user, null, client, authenticationTime);
                    }
                }
                authorizationGrant.setScopes(persistentJwt.getScopes());
                authorizationGrant.setAccessTokens(persistentJwt.getAccessTokens());
                authorizationGrant.setRefreshTokens(persistentJwt.getRefreshTokens());
                authorizationGrant.setLongLivedAccessToken(persistentJwt.getLongLivedAccessToken());
                authorizationGrant.setIdToken(persistentJwt.getIdToken());
                this.grant.addAuthorizationGrant(authorizationGrant);
            }
        }
    }

    @Override
    public List<AuthorizationGrant> getAuthorizationGrants() {
        return this.grant.getAuthorizationGrants();
    }

    @Override
    public void removeAuthorizationGrants(List<AuthorizationGrant> authorizationGrants) {
        this.grant.removeAuthorizationGrants(authorizationGrants);
    }

    @Override
    public void addAuthorizationGrant(AuthorizationGrant authorizationGrant) {
        this.grant.addAuthorizationGrant(authorizationGrant);
    }

    @Override
    public AuthorizationGrant createAuthorizationGrant(User user, Client client, Date authenticationTime) {
        return this.grant.createAuthorizationGrant(user, client, authenticationTime);
    }

    @Override
    public AuthorizationCodeGrant createAuthorizationCodeGrant(User user, Client client, Date authenticationTime) {
        return this.grant.createAuthorizationCodeGrant(user, client, authenticationTime);
    }

    @Override
    public ImplicitGrant createImplicitGrant(User user, Client client, Date authenticationTime) {
        return this.grant.createImplicitGrant(user, client, authenticationTime);
    }

    @Override
    public ClientCredentialsGrant createClientCredentialsGrant(User user, Client client) {
        return this.grant.createClientCredentialsGrant(user, client);
    }

    @Override
    public ResourceOwnerPasswordCredentialsGrant createResourceOwnerPasswordCredentialsGrant(User user, Client client) {
        return this.grant.createResourceOwnerPasswordCredentialsGrant(user, client);
    }

    @Override
    public AuthorizationCodeGrant getAuthorizationCodeGrant(String clientId, String authorizationCode) {
        return this.grant.getAuthorizationCodeGrant(clientId, authorizationCode);
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByRefreshToken(String clientId, String refreshTokenCode) {
        return this.grant.getAuthorizationGrantByRefreshToken(clientId, refreshTokenCode);
    }

    @Override
    public List<AuthorizationGrant> getAuthorizationGrant(String clientId) {
        return this.grant.getAuthorizationGrant(clientId);
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByAccessToken(String tokenCode) {
        return this.grant.getAuthorizationGrantByAccessToken(tokenCode);
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByIdToken(String idToken) {
        return this.grant.getAuthorizationGrantByIdToken(idToken);
    }
}

