/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.security.SignatureException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.oxauth.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.AuthorizationGrantInMemory;
import org.xdi.oxauth.model.common.AuthorizationGrantLdap;
import org.xdi.oxauth.model.common.AuthorizationGrantListLdap;
import org.xdi.oxauth.model.common.AuthorizationGrantType;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.common.IdToken;
import org.xdi.oxauth.model.common.RefreshToken;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.ldap.TokenLdap;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.util.security.StringEncrypter;

public class AuthorizationGrant
implements IAuthorizationGrant {
    private static final Log LOGGER = Logging.getLog(AuthorizationGrantListLdap.class);
    private IAuthorizationGrant grant;

    public AuthorizationGrant(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        switch (ConfigurationFactory.getConfiguration().getModeEnum()) {
            case IN_MEMORY: {
                this.grant = new AuthorizationGrantInMemory(user, authorizationGrantType, client, authenticationTime);
                ((AuthorizationGrantInMemory)this.grant).setParentRef(this);
                break;
            }
            case LDAP: {
                this.grant = new AuthorizationGrantLdap(user, authorizationGrantType, client, authenticationTime);
                break;
            }
            default: {
                LOGGER.error((Object)"Unable to identify mode of the server. (Please check configuration.)", new Object[0]);
                throw new IllegalArgumentException("Unable to identify mode of the server. (Please check configuration.) " + (Object)((Object)ConfigurationFactory.getConfiguration().getModeEnum()));
            }
        }
    }

    public IAuthorizationGrant getGrant() {
        return this.grant;
    }

    @Override
    public String getGrantId() {
        return this.grant.getGrantId();
    }

    @Override
    public void setGrantId(String p_grantId) {
        this.grant.setGrantId(p_grantId);
    }

    @Override
    public AuthorizationCode getAuthorizationCode() {
        return this.grant.getAuthorizationCode();
    }

    @Override
    public void setAuthorizationCode(AuthorizationCode authorizationCode) {
        this.grant.setAuthorizationCode(authorizationCode);
    }

    @Override
    public String getNonce() {
        return this.grant.getNonce();
    }

    @Override
    public void setNonce(String nonce) {
        this.grant.setNonce(nonce);
    }

    @Override
    public AccessToken createAccessToken() {
        return this.grant.createAccessToken();
    }

    @Override
    public AccessToken createLongLivedAccessToken() {
        return this.grant.createLongLivedAccessToken();
    }

    @Override
    public RefreshToken createRefreshToken() {
        return this.grant.createRefreshToken();
    }

    @Override
    public IdToken createIdToken(String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, Map<String, String> claims) throws SignatureException, StringEncrypter.EncryptionException, InvalidJwtException, InvalidJweException {
        IdToken idToken = this.grant.createIdToken(nonce, authorizationCode, accessToken, claims);
        idToken.setAuthLevel(this.getAuthLevel());
        idToken.setAuthMode(this.getAuthMode());
        this.grant.save();
        return idToken;
    }

    @Override
    public RefreshToken getRefreshToken(String refreshTokenCode) {
        return this.grant.getRefreshToken(refreshTokenCode);
    }

    @Override
    public AbstractToken getAccessToken(String tokenCode) {
        return this.grant.getAccessToken(tokenCode);
    }

    @Override
    public boolean isValid() {
        return this.grant.isValid();
    }

    @Override
    public void revokeAllTokens() {
        this.grant.revokeAllTokens();
    }

    @Override
    public void checkExpiredTokens() {
        this.grant.checkExpiredTokens();
    }

    @Override
    public String checkScopesPolicy(String scope) {
        return this.grant.checkScopesPolicy(scope);
    }

    @Override
    public User getUser() {
        return this.grant.getUser();
    }

    @Override
    public String getUserId() {
        return this.grant.getUserId();
    }

    @Override
    public String getUserDn() {
        return this.grant.getUserDn();
    }

    @Override
    public AuthorizationGrantType getAuthorizationGrantType() {
        return this.grant.getAuthorizationGrantType();
    }

    @Override
    public Client getClient() {
        return this.grant.getClient();
    }

    @Override
    public String getClientId() {
        return this.grant.getClientId();
    }

    @Override
    public String getClientDn() {
        return this.grant.getClientDn();
    }

    @Override
    public List<AccessToken> getAccessTokens() {
        return this.grant.getAccessTokens();
    }

    @Override
    public Set<String> getRefreshTokensCodes() {
        return this.grant.getRefreshTokensCodes();
    }

    @Override
    public Set<String> getAccessTokensCodes() {
        return this.grant.getAccessTokensCodes();
    }

    @Override
    public List<RefreshToken> getRefreshTokens() {
        return this.grant.getRefreshTokens();
    }

    @Override
    public void setRefreshTokens(List<RefreshToken> refreshTokens) {
        this.grant.setRefreshTokens(refreshTokens);
    }

    @Override
    public AccessToken getLongLivedAccessToken() {
        return this.grant.getLongLivedAccessToken();
    }

    @Override
    public IdToken getIdToken() {
        return this.grant.getIdToken();
    }

    @Override
    public Set<String> getScopes() {
        return this.grant.getScopes();
    }

    @Override
    public Date getAuthenticationTime() {
        return this.grant.getAuthenticationTime();
    }

    @Override
    public TokenLdap getTokenLdap() {
        return this.grant.getTokenLdap();
    }

    @Override
    public void setTokenLdap(TokenLdap p_tokenLdap) {
        this.grant.setTokenLdap(p_tokenLdap);
    }

    @Override
    public void setLongLivedAccessToken(AccessToken longLivedAccessToken) {
        this.grant.setLongLivedAccessToken(longLivedAccessToken);
    }

    @Override
    public void setIdToken(IdToken idToken) {
        this.grant.setIdToken(idToken);
    }

    @Override
    public void setScopes(Collection<String> scopes) {
        this.grant.setScopes(scopes);
    }

    @Override
    public void setAccessTokens(List<AccessToken> accessTokens) {
        this.grant.setAccessTokens(accessTokens);
    }

    @Override
    public JwtAuthorizationRequest getJwtAuthorizationRequest() {
        return this.grant.getJwtAuthorizationRequest();
    }

    @Override
    public void setJwtAuthorizationRequest(JwtAuthorizationRequest p_jwtAuthorizationRequest) {
        this.grant.setJwtAuthorizationRequest(p_jwtAuthorizationRequest);
    }

    @Override
    public void setAuthLevel(String authLevel) {
        this.grant.setAuthLevel(authLevel);
    }

    @Override
    public String getAuthLevel() {
        return this.grant.getAuthLevel();
    }

    @Override
    public void setAuthMode(String authMode) {
        this.grant.setAuthMode(authMode);
    }

    @Override
    public void save() {
        this.grant.save();
    }

    @Override
    public String getAuthMode() {
        return this.grant.getAuthMode();
    }
}

