/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.authorize;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.authorize.IdTokenMember;
import org.xdi.oxauth.model.authorize.UserInfoMember;
import org.xdi.oxauth.model.common.Display;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.crypto.Certificate;
import org.xdi.oxauth.model.crypto.PublicKey;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwe.JweDecrypterImpl;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.model.jwt.JwtHeader;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.model.util.Util;
import org.xdi.util.security.StringEncrypter;

public class JwtAuthorizationRequest {
    private String type;
    private String algorithm;
    private String encryptionAlgorithm;
    private String keyId;
    private List<ResponseType> responseTypes;
    private String clientId;
    private List<String> scopes;
    private String redirectUri;
    private String nonce;
    private String state;
    private Display display;
    private List<Prompt> prompts;
    private UserInfoMember userInfoMember;
    private IdTokenMember idTokenMember;
    private String encodedJwt;

    public JwtAuthorizationRequest(String encodedJwt, Client client) throws InvalidJwtException, InvalidJweException {
        block35: {
            try {
                this.responseTypes = new ArrayList<ResponseType>();
                this.scopes = new ArrayList<String>();
                this.prompts = new ArrayList<Prompt>();
                this.encodedJwt = encodedJwt;
                if (encodedJwt != null && !encodedJwt.isEmpty()) {
                    String[] parts = encodedJwt.split("\\.");
                    if (parts.length == 5) {
                        String encodedHeader = parts[0];
                        String encodedEncryptedKey = parts[1];
                        String encodedInitializationVector = parts[2];
                        String encodedCipherText = parts[3];
                        String encodedIntegrityValue = parts[4];
                        JwtHeader jwtHeader = new JwtHeader(encodedHeader);
                        KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)jwtHeader.getClaimAsString("alg"));
                        BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)jwtHeader.getClaimAsString("enc"));
                        JweDecrypterImpl jweDecrypter = null;
                        if ("RSA".equals(keyEncryptionAlgorithm.getFamily())) {
                            JSONWebKeySet jwks = ConfigurationFactory.getWebKeys();
                            JSONWebKey jwk = jwks.getKeyByAlgorithm("RS256");
                            RSAPrivateKey rsaPrivateKey = new RSAPrivateKey(jwk.getPrivateKey().getModulus(), jwk.getPrivateKey().getPrivateExponent());
                            jweDecrypter = new JweDecrypterImpl(rsaPrivateKey);
                        } else {
                            jweDecrypter = new JweDecrypterImpl(client.getClientSecret().getBytes("UTF-8"));
                        }
                        jweDecrypter.setKeyEncryptionAlgorithm(keyEncryptionAlgorithm);
                        jweDecrypter.setBlockEncryptionAlgorithm(blockEncryptionAlgorithm);
                        byte[] contentMasterKey = jweDecrypter.decryptEncryptionKey(encodedEncryptedKey);
                        byte[] initializationVector = JwtUtil.base64urldecode((String)encodedInitializationVector);
                        byte[] authenticationTag = JwtUtil.base64urldecode((String)encodedIntegrityValue);
                        String additionalAuthenticatedData = encodedHeader + "." + encodedEncryptedKey + "." + encodedInitializationVector;
                        String encodedClaim = jweDecrypter.decryptCipherText(encodedCipherText, contentMasterKey, initializationVector, authenticationTag, additionalAuthenticatedData.getBytes("UTF-8"));
                        String header = new String(JwtUtil.base64urldecode((String)encodedHeader), "UTF-8");
                        String payload = new String(JwtUtil.base64urldecode((String)encodedClaim), "UTF-8");
                        payload = payload.replace("\\", "");
                        this.loadHeader(header);
                        this.loadPayload(payload);
                        break block35;
                    }
                    if (parts.length == 2 || parts.length == 3) {
                        SignatureAlgorithm sigAlg;
                        String encodedHeader = parts[0];
                        String encodedClaim = parts[1];
                        String encodedSignature = "";
                        if (parts.length == 3) {
                            encodedSignature = parts[2];
                        }
                        String signingInput = encodedHeader + "." + encodedClaim;
                        String header = new String(JwtUtil.base64urldecode((String)encodedHeader), "UTF-8");
                        String payload = new String(JwtUtil.base64urldecode((String)encodedClaim), "UTF-8");
                        payload = payload.replace("\\", "");
                        byte[] signature = JwtUtil.base64urldecode((String)encodedSignature);
                        JSONObject jsonHeader = new JSONObject(header);
                        if (jsonHeader.has("typ")) {
                            this.type = jsonHeader.getString("typ");
                        }
                        if (jsonHeader.has("alg")) {
                            this.algorithm = jsonHeader.getString("alg");
                        }
                        if (jsonHeader.has("kid")) {
                            this.keyId = jsonHeader.getString("kid");
                        }
                        if ((sigAlg = SignatureAlgorithm.fromName((String)this.algorithm)) != null) {
                            if (this.validateSignature(sigAlg, client, signingInput, signature)) {
                                int i;
                                JSONObject jsonPayload = new JSONObject(payload);
                                if (jsonPayload.has("response_type")) {
                                    JSONArray responseTypeJsonArray = jsonPayload.optJSONArray("response_type");
                                    if (responseTypeJsonArray != null) {
                                        for (i = 0; i < responseTypeJsonArray.length(); ++i) {
                                            ResponseType responseType = ResponseType.fromString((String)responseTypeJsonArray.getString(i));
                                            this.responseTypes.add(responseType);
                                        }
                                    } else {
                                        this.responseTypes.addAll(ResponseType.fromString((String)jsonPayload.getString("response_type"), (String)" "));
                                    }
                                }
                                if (jsonPayload.has("client_id")) {
                                    this.clientId = jsonPayload.getString("client_id");
                                }
                                if (jsonPayload.has("scope")) {
                                    JSONArray scopesJsonArray = jsonPayload.optJSONArray("scope");
                                    if (scopesJsonArray != null) {
                                        for (i = 0; i < scopesJsonArray.length(); ++i) {
                                            String scope = scopesJsonArray.getString(i);
                                            this.scopes.add(scope);
                                        }
                                    } else {
                                        String scopeStringList = jsonPayload.getString("scope");
                                        this.scopes.addAll(Util.splittedStringAsList((String)scopeStringList, (String)" "));
                                    }
                                }
                                if (jsonPayload.has("redirect_uri")) {
                                    this.redirectUri = URLDecoder.decode(jsonPayload.getString("redirect_uri"), "UTF-8");
                                }
                                if (jsonPayload.has("nonce")) {
                                    this.nonce = jsonPayload.getString("nonce");
                                }
                                if (jsonPayload.has("state")) {
                                    this.state = jsonPayload.getString("state");
                                }
                                if (jsonPayload.has("display")) {
                                    this.display = Display.fromString((String)jsonPayload.getString("display"));
                                }
                                if (jsonPayload.has("prompt")) {
                                    JSONArray promptJsonArray = jsonPayload.optJSONArray("prompt");
                                    if (promptJsonArray != null) {
                                        for (int i2 = 0; i2 < promptJsonArray.length(); ++i2) {
                                            Prompt prompt = Prompt.fromString((String)promptJsonArray.getString(i2));
                                            this.prompts.add(prompt);
                                        }
                                    } else {
                                        this.prompts.addAll(Prompt.fromString((String)jsonPayload.getString("prompt"), (String)" "));
                                    }
                                }
                                if (jsonPayload.has("userinfo")) {
                                    this.userInfoMember = new UserInfoMember(jsonPayload.getJSONObject("userinfo"));
                                }
                                if (jsonPayload.has("id_token")) {
                                    this.idTokenMember = new IdTokenMember(jsonPayload.getJSONObject("id_token"));
                                }
                                break block35;
                            }
                            throw new InvalidJwtException("The JWT signature is not valid");
                        }
                        throw new InvalidJwtException("The JWT algorithm is not supported");
                    }
                    throw new InvalidJwtException("The JWT is not well formed");
                }
                throw new InvalidJwtException("The JWT is null or empty");
            }
            catch (JSONException e) {
                throw new InvalidJwtException((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidJwtException((Throwable)e);
            }
            catch (StringEncrypter.EncryptionException e) {
                throw new InvalidJwtException((Throwable)e);
            }
            catch (Exception e) {
                throw new InvalidJwtException((Throwable)e);
            }
        }
    }

    public String getEncodedJwt() {
        return this.encodedJwt;
    }

    private void loadHeader(String header) throws JSONException {
        JSONObject jsonHeader = new JSONObject(header);
        if (jsonHeader.has("typ")) {
            this.type = jsonHeader.getString("typ");
        }
        if (jsonHeader.has("alg")) {
            this.algorithm = jsonHeader.getString("alg");
        }
        if (jsonHeader.has("enc")) {
            this.encryptionAlgorithm = jsonHeader.getString("enc");
        }
        if (jsonHeader.has("kid")) {
            this.keyId = jsonHeader.getString("kid");
        }
    }

    private void loadPayload(String payload) throws JSONException, UnsupportedEncodingException {
        int i;
        JSONObject jsonPayload = new JSONObject(payload);
        if (jsonPayload.has("response_type")) {
            JSONArray responseTypeJsonArray = jsonPayload.optJSONArray("response_type");
            if (responseTypeJsonArray != null) {
                for (i = 0; i < responseTypeJsonArray.length(); ++i) {
                    ResponseType responseType = ResponseType.fromString((String)responseTypeJsonArray.getString(i));
                    this.responseTypes.add(responseType);
                }
            } else {
                this.responseTypes.addAll(ResponseType.fromString((String)jsonPayload.getString("response_type"), (String)" "));
            }
        }
        if (jsonPayload.has("client_id")) {
            this.clientId = jsonPayload.getString("client_id");
        }
        if (jsonPayload.has("scope")) {
            JSONArray scopesJsonArray = jsonPayload.optJSONArray("scope");
            if (scopesJsonArray != null) {
                for (i = 0; i < scopesJsonArray.length(); ++i) {
                    String scope = scopesJsonArray.getString(i);
                    this.scopes.add(scope);
                }
            } else {
                String scopeStringList = jsonPayload.getString("scope");
                this.scopes.addAll(Util.splittedStringAsList((String)scopeStringList, (String)" "));
            }
        }
        if (jsonPayload.has("redirect_uri")) {
            this.redirectUri = URLDecoder.decode(jsonPayload.getString("redirect_uri"), "UTF-8");
        }
        if (jsonPayload.has("nonce")) {
            this.nonce = jsonPayload.getString("nonce");
        }
        if (jsonPayload.has("state")) {
            this.state = jsonPayload.getString("state");
        }
        if (jsonPayload.has("display")) {
            this.display = Display.fromString((String)jsonPayload.getString("display"));
        }
        if (jsonPayload.has("prompt")) {
            JSONArray promptJsonArray = jsonPayload.optJSONArray("prompt");
            if (promptJsonArray != null) {
                for (int i2 = 0; i2 < promptJsonArray.length(); ++i2) {
                    Prompt prompt = Prompt.fromString((String)promptJsonArray.getString(i2));
                    this.prompts.add(prompt);
                }
            } else {
                this.prompts.addAll(Prompt.fromString((String)jsonPayload.getString("prompt"), (String)" "));
            }
        }
        if (jsonPayload.has("userinfo")) {
            this.userInfoMember = new UserInfoMember(jsonPayload.getJSONObject("userinfo"));
        }
        if (jsonPayload.has("id_token")) {
            this.idTokenMember = new IdTokenMember(jsonPayload.getJSONObject("id_token"));
        }
    }

    private boolean validateSignature(SignatureAlgorithm signatureAlgorithm, Client client, String signingInput, byte[] signature) throws InvalidJwtException {
        boolean validSignature = false;
        try {
            SignatureAlgorithm clientSignatureAlgorithm;
            if (StringUtils.isNotBlank((String)client.getRequestObjectSigningAlg()) && signatureAlgorithm != (clientSignatureAlgorithm = SignatureAlgorithm.fromName((String)client.getRequestObjectSigningAlg()))) {
                return false;
            }
            if (signatureAlgorithm == SignatureAlgorithm.NONE) {
                return true;
            }
            if (signatureAlgorithm == SignatureAlgorithm.HS256 || signatureAlgorithm == SignatureAlgorithm.HS384 || signatureAlgorithm == SignatureAlgorithm.HS512) {
                String sharedKey = client.getClientSecret();
                byte[] signature2 = null;
                switch (signatureAlgorithm) {
                    case HS256: {
                        signature2 = JwtUtil.getSignatureHS256((byte[])signingInput.getBytes("UTF-8"), (byte[])sharedKey.getBytes("UTF-8"));
                        validSignature = Arrays.equals(signature, signature2);
                        break;
                    }
                    case HS384: {
                        signature2 = JwtUtil.getSignatureHS384((byte[])signingInput.getBytes("UTF-8"), (byte[])sharedKey.getBytes("UTF-8"));
                        validSignature = Arrays.equals(signature, signature2);
                        break;
                    }
                    case HS512: {
                        signature2 = JwtUtil.getSignatureHS512((byte[])signingInput.getBytes("UTF-8"), (byte[])sharedKey.getBytes("UTF-8"));
                        validSignature = Arrays.equals(signature, signature2);
                        break;
                    }
                    default: {
                        throw new InvalidJwtException("The algorithm is not supported");
                    }
                }
            } else if (client.getJwksUri() != null) {
                PublicKey publicKey = JwtUtil.getPublicKey((String)client.getJwksUri(), (SignatureAlgorithm)signatureAlgorithm, (String)this.keyId);
                if (publicKey == null) {
                    throw new InvalidJwtException("Cannot retrieve the JWK file");
                }
                if (publicKey.getCertificate() != null) {
                    Certificate cert = publicKey.getCertificate();
                    Object signature2 = null;
                    switch (signatureAlgorithm) {
                        case RS256: {
                            validSignature = JwtUtil.verifySignatureRS256((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (RSAPublicKey)cert.getRsaPublicKey());
                            break;
                        }
                        case RS384: {
                            validSignature = JwtUtil.verifySignatureRS384((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (RSAPublicKey)cert.getRsaPublicKey());
                            break;
                        }
                        case RS512: {
                            validSignature = JwtUtil.verifySignatureRS512((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (RSAPublicKey)cert.getRsaPublicKey());
                            break;
                        }
                        case ES256: {
                            validSignature = JwtUtil.verifySignatureES256((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (ECDSAPublicKey)cert.getEcdsaPublicKey());
                            break;
                        }
                        case ES384: {
                            validSignature = JwtUtil.verifySignatureES384((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (ECDSAPublicKey)cert.getEcdsaPublicKey());
                            break;
                        }
                        case ES512: {
                            validSignature = JwtUtil.verifySignatureES512((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (ECDSAPublicKey)cert.getEcdsaPublicKey());
                            break;
                        }
                        default: {
                            throw new InvalidJwtException("The algorithm is not supported");
                        }
                    }
                } else {
                    Object signature2 = null;
                    switch (signatureAlgorithm) {
                        case RS256: {
                            validSignature = JwtUtil.verifySignatureRS256((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (RSAPublicKey)((RSAPublicKey)publicKey));
                            break;
                        }
                        case RS384: {
                            validSignature = JwtUtil.verifySignatureRS384((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (RSAPublicKey)((RSAPublicKey)publicKey));
                            break;
                        }
                        case RS512: {
                            validSignature = JwtUtil.verifySignatureRS512((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (RSAPublicKey)((RSAPublicKey)publicKey));
                            break;
                        }
                        case ES256: {
                            validSignature = JwtUtil.verifySignatureES256((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (ECDSAPublicKey)((ECDSAPublicKey)publicKey));
                            break;
                        }
                        case ES384: {
                            validSignature = JwtUtil.verifySignatureES384((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (ECDSAPublicKey)((ECDSAPublicKey)publicKey));
                            break;
                        }
                        case ES512: {
                            validSignature = JwtUtil.verifySignatureES512((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (ECDSAPublicKey)((ECDSAPublicKey)publicKey));
                            break;
                        }
                        default: {
                            throw new InvalidJwtException("The algorithm is not supported");
                        }
                    }
                }
            }
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new InvalidJwtException((Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new InvalidJwtException((Throwable)e);
        }
        catch (SignatureException e) {
            throw new InvalidJwtException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidJwtException((Throwable)e);
        }
        catch (NoSuchProviderException e) {
            throw new InvalidJwtException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJwtException((Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidJwtException((Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidJwtException((Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new InvalidJwtException((Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new InvalidJwtException((Throwable)e);
        }
        catch (IOException e) {
            throw new InvalidJwtException((Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidJwtException((Throwable)e);
        }
        return validSignature;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public List<Prompt> getPrompts() {
        return this.prompts;
    }

    public void setPrompts(List<Prompt> prompts) {
        this.prompts = prompts;
    }

    public UserInfoMember getUserInfoMember() {
        return this.userInfoMember;
    }

    public void setUserInfoMember(UserInfoMember userInfoMember) {
        this.userInfoMember = userInfoMember;
    }

    public IdTokenMember getIdTokenMember() {
        return this.idTokenMember;
    }

    public void setIdTokenMember(IdTokenMember idTokenMember) {
        this.idTokenMember = idTokenMember;
    }
}

