/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.authorize;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.registration.Client;

public class AuthorizeParamsValidator {
    public static boolean validateParams(String responseType, String clientId, List<Prompt> prompts, String nonce, String request, String requestUri) {
        List responseTypes = ResponseType.fromString((String)responseType, (String)" ");
        if (responseTypes.contains(ResponseType.TOKEN) && StringUtils.isBlank((String)nonce)) {
            return false;
        }
        if (StringUtils.isNotBlank((String)request) && StringUtils.isNotBlank((String)requestUri)) {
            return false;
        }
        boolean validParams = responseType != null && !responseType.isEmpty() && clientId != null && !clientId.isEmpty();
        return validParams && AuthorizeParamsValidator.validatePrompt(prompts);
    }

    public static boolean validatePrompt(List<Prompt> prompts) {
        return !prompts.contains(Prompt.NONE) || prompts.size() <= 1;
    }

    public static boolean validateResponseTypes(List<ResponseType> responseTypes, Client client) {
        if (responseTypes == null || responseTypes.isEmpty() || client == null || client.getResponseTypes() == null) {
            return false;
        }
        List<ResponseType> clientSupportedResponseTypes = Arrays.asList(client.getResponseTypes());
        return clientSupportedResponseTypes.containsAll(responseTypes);
    }
}

