/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.jwk.ws.rs;

import java.util.Collection;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.jwk.ws.rs.JwkRestWebService;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.jwk.JSONWebKey;

@Name(value="requestJwkRestWebService")
public class JwkRestWebServiceImpl
implements JwkRestWebService {
    @Logger
    private Log log;

    @Override
    public Response requestJwk(SecurityContext sec) {
        this.log.debug((Object)"Attempting to request JWK, Is Secure = {0}", new Object[]{sec.isSecure()});
        Response.ResponseBuilder builder = Response.ok();
        builder.entity((Object)this.getJSonResponse());
        return builder.build();
    }

    public String getJSonResponse() {
        JSONObject jsonObj = new JSONObject();
        JSONArray keys = new JSONArray();
        try {
            for (JSONWebKey JSONWebKey2 : ConfigurationFactory.getWebKeys().getKeys()) {
                JSONObject jsonKeyValue = new JSONObject();
                if (JSONWebKey2.getKeyType() != null) {
                    jsonKeyValue.put("kty", (Object)JSONWebKey2.getKeyType());
                }
                if (JSONWebKey2.getKeyId() != null) {
                    jsonKeyValue.put("kid", (Object)JSONWebKey2.getKeyId());
                }
                if (JSONWebKey2.getUse() != null) {
                    jsonKeyValue.put("use", (Object)JSONWebKey2.getUse());
                }
                if (JSONWebKey2.getAlgorithm() != null) {
                    jsonKeyValue.put("alg", (Object)JSONWebKey2.getAlgorithm());
                }
                if (JSONWebKey2.getCurve() != null) {
                    jsonKeyValue.put("crv", (Object)JSONWebKey2.getCurve());
                }
                if (JSONWebKey2.getPublicKey() == null) continue;
                if (JSONWebKey2.getPublicKey().getModulus() != null) {
                    jsonKeyValue.put("n", (Object)JSONWebKey2.getPublicKey().getModulus());
                }
                if (JSONWebKey2.getPublicKey().getExponent() != null) {
                    jsonKeyValue.put("e", (Object)JSONWebKey2.getPublicKey().getExponent());
                }
                if (JSONWebKey2.getPublicKey().getX() != null) {
                    jsonKeyValue.put("x", (Object)JSONWebKey2.getPublicKey().getX());
                }
                if (JSONWebKey2.getPublicKey().getY() != null) {
                    jsonKeyValue.put("y", (Object)JSONWebKey2.getPublicKey().getY());
                }
                if (JSONWebKey2.getCertificateChain() != null) {
                    jsonKeyValue.put("x5c", (Object)new JSONArray((Collection)JSONWebKey2.getCertificateChain()));
                }
                keys.put((Object)jsonKeyValue);
            }
            jsonObj.put("keys", (Object)keys);
            return jsonObj.toString(4);
        }
        catch (JSONException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }
}

