/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.FederationMetadataClient;
import org.xdi.oxauth.client.FederationMetadataRequest;
import org.xdi.oxauth.client.FederationMetadataResponse;
import org.xdi.oxauth.model.federation.FederationMetadata;
import org.xdi.oxauth.model.federation.FederationOP;
import org.xdi.oxauth.model.federation.FederationRP;

public class FederationMetadataEmbeddedTest
extends BaseTest {
    @Parameters(value={"federationMetadataPath"})
    @Test
    public void requestExistingFederationMetadataIdList(String federationMetadataPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, federationMetadataPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                FederationMetadataRequest r = new FederationMetadataRequest();
                request.setQueryString(r.getQueryString());
                BaseTest.output("Request url:" + request.getRequestURI());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestExistingFederationMetadataIdList", response);
                String contentAsString = response.getContentAsString();
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)contentAsString, (String)("Unexpected result: " + contentAsString));
                try {
                    List list = FederationMetadataClient.convertMetadataIdList((String)contentAsString);
                    Assert.assertTrue((list != null && !list.isEmpty() ? 1 : 0) != 0, (String)"MetadataId list is empty. It's expected to have not empty list");
                }
                catch (JSONException e) {
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + contentAsString), (Throwable)e);
                }
                catch (Exception e) {
                    BaseTest.fails(e);
                }
            }
        }.run();
    }

    @Parameters(value={"federationMetadataPath", "federationMetadataId"})
    @Test
    public void requestFederationMetadataByIdSigned(String federationMetadataPath, String federationMetadataId) throws Exception {
        this.baseTest(federationMetadataPath, federationMetadataId, true);
    }

    @Parameters(value={"federationMetadataPath", "federationMetadataId"})
    @Test
    public void requestFederationMetadataByIdNotSigned(String federationMetadataPath, String federationMetadataId) throws Exception {
        this.baseTest(federationMetadataPath, federationMetadataId, false);
    }

    @Parameters(value={"federationMetadataPath"})
    @Test
    public void requestFederationMetadataByIdFail(String federationMetadataPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, federationMetadataPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                FederationMetadataRequest r = new FederationMetadataRequest("notExistingId");
                request.setQueryString(r.getQueryString());
                BaseTest.output("Request url:" + request.getRequestURI());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestFederationMetadataByIdFail", response);
                String contentAsString = response.getContentAsString();
                FederationMetadataResponse federationResponse = new FederationMetadataResponse();
                federationResponse.injectErrorIfExistSilently(contentAsString);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. Entity: " + contentAsString));
                Assert.assertNotNull((Object)contentAsString, (String)"The entity is null");
                Assert.assertNotNull((Object)federationResponse.getErrorType(), (String)"The error type is null");
                Assert.assertNotNull((Object)federationResponse.getErrorDescription(), (String)"The error description is null");
            }
        }.run();
    }

    private void baseTest(String federationMetadataPath, final String federationMetadataId, final boolean p_signed) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, federationMetadataPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                FederationMetadataRequest r = new FederationMetadataRequest(federationMetadataId);
                r.setSigned(p_signed);
                request.setQueryString(r.getQueryString());
                BaseTest.output("Request url:" + request.getRequestURI());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestFederationMetadataByIdSigned", response);
                String contentAsString = response.getContentAsString();
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)contentAsString, (String)("Unexpected result: " + contentAsString));
                try {
                    FederationMetadataResponse r = new FederationMetadataResponse();
                    FederationMetadataClient.fillResponse((FederationMetadataResponse)r, (String)contentAsString, (boolean)p_signed);
                    FederationMetadata metadata = r.getMetadata();
                    Assert.assertNotNull((Object)metadata, (String)"The metadata is null");
                    Assert.assertNotNull((Object)metadata.getId(), (String)"The metadata id is null");
                    Assert.assertNotNull((Object)metadata.getDisplayName(), (String)"The metadata displayName is null");
                    Assert.assertNotNull((Object)metadata.getIntervalCheck(), (String)"The metadata intervalCheck is not set");
                    List rpList = metadata.getRpList();
                    List opList = metadata.getOpList();
                    Assert.assertTrue((rpList != null && !rpList.isEmpty() ? 1 : 0) != 0, (String)"The metadata rp list is not set");
                    Assert.assertTrue((opList != null && !opList.isEmpty() ? 1 : 0) != 0, (String)"The metadata op list is not set");
                    Assert.assertNotNull((Object)((FederationRP)rpList.get(0)).getDisplayName(), (String)"The metadata rp's display_name attribute is not set");
                    Assert.assertNotNull((Object)((FederationRP)rpList.get(0)).getRedirectUri(), (String)"The metadata rp's redirect_uri attribute is not set");
                    Assert.assertNotNull((Object)((FederationOP)opList.get(0)).getDisplayName(), (String)"The metadata op's display_name attribute is not set");
                    Assert.assertNotNull((Object)((FederationOP)opList.get(0)).getOpId(), (String)"The metadata op's op_id attribute is not set");
                    Assert.assertNotNull((Object)((FederationOP)opList.get(0)).getDomain(), (String)"The metadata op's domain attribute is not set");
                }
                catch (Exception e) {
                    BaseTest.fails(e);
                }
            }
        }.run();
    }
}

