/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.ClientInfoRequest;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;

public class ClientInfoRestWebServiceEmbeddedTest
extends BaseTest {
    private String accessToken1;
    private String accessToken2;
    private String accessToken3;

    @Parameters(value={"authorizePath", "userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void requestClientInfoStep1ImplicitFlow(String authorizePath, final String userId, final String userSecret, final String clientId, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.TOKEN);
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("clientinfo");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientInfo step 1 Implicit Flow", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                        Assert.assertNotNull(params.get("expires_in"), (String)"The expires in value is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                        Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                        ClientInfoRestWebServiceEmbeddedTest.this.accessToken1 = (String)params.get("access_token");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)"Unexpected error");
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"clientInfoPath"})
    @Test(dependsOnMethods={"requestClientInfoStep1ImplicitFlow"})
    public void requestClientInfoStep2PostImplicitFlow(String clientInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, clientInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + ClientInfoRestWebServiceEmbeddedTest.this.accessToken1));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                ClientInfoRequest clientInfoRequest = new ClientInfoRequest(null);
                request.addParameters(clientInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientInfo step 2 POST Implicit Flow", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("displayName"), (String)"Unexpected result: displayName not found");
                    Assert.assertTrue((boolean)jsonObj.has("inum"), (String)"Unexpected result: inum not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthAppType"), (String)"Unexpected result: oxAuthAppType not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthIdTokenSignedResponseAlg"), (String)"Unexpected result: oxAuthIdTokenSignedResponseAlg not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthRedirectURI"), (String)"Unexpected result: oxAuthRedirectURI not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthScope"), (String)"Unexpected result: oxAuthScope not found");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"clientInfoPath"})
    @Test(dependsOnMethods={"requestClientInfoStep1ImplicitFlow"})
    public void requestClientInfoStep2GetImplicitFlow(String clientInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, clientInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + ClientInfoRestWebServiceEmbeddedTest.this.accessToken1));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                ClientInfoRequest clientInfoRequest = new ClientInfoRequest(null);
                request.setQueryString(clientInfoRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientInfo step 2 GET Implicit Flow", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("displayName"), (String)"Unexpected result: displayName not found");
                    Assert.assertTrue((boolean)jsonObj.has("inum"), (String)"Unexpected result: inum not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthAppType"), (String)"Unexpected result: oxAuthAppType not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthIdTokenSignedResponseAlg"), (String)"Unexpected result: oxAuthIdTokenSignedResponseAlg not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthRedirectURI"), (String)"Unexpected result: oxAuthRedirectURI not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthScope"), (String)"Unexpected result: oxAuthScope not found");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "userId", "userSecret", "clientId", "clientSecret"})
    @Test
    public void requestClientInfoStep1PasswordFlow(String tokenPath, final String userId, final String userSecret, final String clientId, final String clientSecret) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
                tokenRequest.setUsername(userId);
                tokenRequest.setPassword(userSecret);
                tokenRequest.setScope("clientinfo");
                tokenRequest.setAuthUsername(clientId);
                tokenRequest.setAuthPassword(clientSecret);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientInfoStep1PasswordFlow", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertTrue((!response.getContentAsString().equals(null) ? 1 : 0) != 0, (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
                    ClientInfoRestWebServiceEmbeddedTest.this.accessToken3 = jsonObj.getString("access_token");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"clientInfoPath"})
    @Test(dependsOnMethods={"requestClientInfoStep1PasswordFlow"})
    public void requestClientInfoStep2PasswordFlow(String clientInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, clientInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + ClientInfoRestWebServiceEmbeddedTest.this.accessToken3));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                ClientInfoRequest clientInfoRequest = new ClientInfoRequest(null);
                request.addParameters(clientInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoStep2PasswordFlow", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("displayName"), (String)"Unexpected result: displayName not found");
                    Assert.assertTrue((boolean)jsonObj.has("inum"), (String)"Unexpected result: inum not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthAppType"), (String)"Unexpected result: oxAuthAppType not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthIdTokenSignedResponseAlg"), (String)"Unexpected result: oxAuthIdTokenSignedResponseAlg not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthRedirectURI"), (String)"Unexpected result: oxAuthRedirectURI not found");
                    Assert.assertTrue((boolean)jsonObj.has("oxAuthScope"), (String)"Unexpected result: oxAuthScope not found");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"clientInfoPath"})
    @Test
    public void requestClientInfoInvalidRequest(String clientInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, clientInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                ClientInfoRequest clientInfoRequest = new ClientInfoRequest(null);
                request.addParameters(clientInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientInfoInvalidRequest", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                    Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"clientInfoPath"})
    @Test
    public void requestClientInfoInvalidToken(String clientInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, clientInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                ClientInfoRequest clientInfoRequest = new ClientInfoRequest("INVALID-TOKEN");
                clientInfoRequest.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
                request.addParameters(clientInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientInfoInvalidToken", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                    Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }
}

