/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma;

import java.io.IOException;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.uma.MetadataConfiguration;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.util.ServerUtil;

class TConfiguration {
    private final BaseTest m_baseTest;
    private MetadataConfiguration m_configuration = null;

    public TConfiguration(BaseTest p_baseTest) {
        Assert.assertNotNull((Object)((Object)p_baseTest));
        this.m_baseTest = p_baseTest;
    }

    public MetadataConfiguration getConfiguration(String umaConfigurationPath) {
        if (this.m_configuration == null) {
            try {
                this.configuration(umaConfigurationPath);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
        UmaTestUtil.assert_((MetadataConfiguration)this.m_configuration);
        return this.m_configuration;
    }

    private void configuration(String umaConfigurationPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.GET, umaConfigurationPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Accept", (Object)"application/json");
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("UMA : TConfiguration.configuration", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                try {
                    TConfiguration.this.m_configuration = (MetadataConfiguration)ServerUtil.createJsonMapper().readValue(response.getContentAsString(), MetadataConfiguration.class);
                    UmaTestUtil.assert_((MetadataConfiguration)TConfiguration.this.m_configuration);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail();
                }
            }
        }.run();
    }
}

