/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.dev;

import java.io.File;
import java.util.Date;
import java.util.Properties;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.OperationsFacade;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.util.FileConfiguration;
import org.xdi.util.security.PropertiesDecrypter;
import org.xdi.util.security.StringEncrypter;

public class Manual {
    public static String LDAP_CONF_FILE_NAME = "oxauth-ldap.properties";
    public static final String CONF_FOLDER = "conf";
    private static final String LDAP_FILE_PATH = "conf" + File.separator + LDAP_CONF_FILE_NAME;
    public static LdapEntryManager MANAGER = null;

    @BeforeClass
    public void init() {
        FileConfiguration fileConfiguration = new FileConfiguration(LDAP_FILE_PATH);
        Properties props = PropertiesDecrypter.decryptProperties((Properties)fileConfiguration.getProperties());
        LDAPConnectionProvider connectionProvider = new LDAPConnectionProvider(props);
        MANAGER = new LdapEntryManager(new OperationsFacade(connectionProvider));
    }

    @AfterClass
    public void destroy() {
        MANAGER.getLdapOperationService().getConnectionPool().close();
    }

    @Test
    public void addGroupsToClient() throws StringEncrypter.EncryptionException {
        Client c = new Client();
        c.setDn("inum=@!0000!0008!7652.0000,ou=clients,o=@!1111,o=gluu");
        c.setClientId("@!0000!0008!7652.0000");
        c.setClientName("web");
        c.setApplicationType("web");
        c.setClientSecretExpiresAt(new Date());
        c.setClientSecret("00000000-0000-0000-0000-097337e87435");
        c.setUserGroups(new String[]{"inum=@!1111!0003!D9B4,ou=groups,o=@!1111,o=gluu", "inum=@!1111!0003!A3F4,ou=groups,o=@!1111,o=gluu"});
        MANAGER.persist((Object)c);
    }

    @Test
    public void getGroupsFromClient() {
        Client client = (Client)MANAGER.find(Client.class, (Object)"inum=@!0000!0008!7652.0000,ou=clients,o=@!1111,o=gluu");
        System.out.println(client);
    }
}

