/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.comp;

import java.util.Date;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseComponentTest;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.service.SessionIdService;

public class SessionIdServiceTest
extends BaseComponentTest {
    private SessionId m_sessionId;
    private SessionIdService m_service;

    @Override
    public void beforeClass() {
        this.m_service = SessionIdService.instance();
        this.m_sessionId = this.m_service.generateSessionId("dummyDn");
    }

    @Override
    public void afterClass() {
        if (this.m_sessionId != null) {
            this.getLdapManager().remove((Object)this.m_sessionId);
        }
    }

    @Test
    public void testUpdateLastUsedDate() {
        SessionId fromLdap1 = this.m_service.getSessionByDN(this.m_sessionId.getDn());
        Date createdDate = this.m_sessionId.getLastUsedAt();
        System.out.println("Created date = " + createdDate);
        Assert.assertEquals((Object)createdDate, (Object)fromLdap1.getLastUsedAt());
        SessionIdServiceTest.sleepSeconds(1);
        this.m_service.updateSessionWithLastUsedDate(this.m_sessionId);
        SessionId fromLdap2 = this.m_service.getSessionByDN(this.m_sessionId.getDn());
        System.out.println("Updated date = " + fromLdap2.getLastUsedAt());
        Assert.assertTrue((boolean)createdDate.before(fromLdap2.getLastUsedAt()));
    }

    @Test
    public void testUpdateAttributes() {
        String clientId = "testClientId";
        SessionId fromLdap1 = this.m_service.getSessionByDN(this.m_sessionId.getDn());
        Date createdDate = this.m_sessionId.getLastUsedAt();
        Assert.assertEquals((Object)createdDate, (Object)fromLdap1.getLastUsedAt());
        Assert.assertNull((Object)fromLdap1.getAuthenticationTime());
        Assert.assertFalse((boolean)fromLdap1.isPermissionGrantedForClient("testClientId"));
        SessionIdServiceTest.sleepSeconds(1);
        this.m_sessionId.setAuthenticationTime(new Date());
        this.m_sessionId.addPermission("testClientId", Boolean.valueOf(true));
        this.m_service.updateSessionWithLastUsedDate(this.m_sessionId);
        SessionId fromLdap2 = this.m_service.getSessionByDN(this.m_sessionId.getDn());
        Assert.assertTrue((boolean)createdDate.before(fromLdap2.getLastUsedAt()));
        Assert.assertNotNull((Object)fromLdap2.getAuthenticationTime());
        Assert.assertTrue((boolean)fromLdap2.isPermissionGrantedForClient("testClientId"));
    }

    @Test
    public void testOldSessionsIdentification() {
        SessionIdServiceTest.sleepSeconds(2);
        Assert.assertTrue((boolean)this.m_service.getIdsOlderThan(1).contains(this.m_sessionId));
        Assert.assertTrue((!this.m_service.getIdsOlderThan(10).contains(this.m_sessionId) ? 1 : 0) != 0);
    }
}

