/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.comp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseComponentTest;
import org.xdi.oxauth.comp.InumGeneratorTest;
import org.xdi.oxauth.idgen.ws.rs.IdGenService;
import org.xdi.oxauth.model.config.Conf;
import org.xdi.oxauth.model.config.ConfigurationFactory;

public class IdGenServiceTest
extends BaseComponentTest {
    @Override
    public void beforeClass() {
        InputStream inputStream = InumGeneratorTest.class.getResourceAsStream("/id/gen/SampleIdGenerator.py");
        try {
            String dn = ConfigurationFactory.getLdapConfiguration().getString("configurationEntryDN");
            Conf conf = (Conf)this.getLdapManager().find(Conf.class, (Object)dn);
            conf.setIdGeneratorScript(IOUtils.toString((InputStream)inputStream));
            this.getLdapManager().merge((Object)conf);
            ConfigurationFactory.updateFromLdap();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterClass() {
        try {
            String dn = ConfigurationFactory.getLdapConfiguration().getString("configurationEntryDN");
            Conf conf = (Conf)this.getLdapManager().find(Conf.class, (Object)dn);
            conf.setIdGeneratorScript("");
            this.getLdapManager().merge((Object)conf);
        }
        finally {
            ConfigurationFactory.updateFromLdap();
        }
    }

    @Test
    public void testCustomIdGenerationByPythonScript() {
        IdGenService instance = IdGenService.instance();
        String uuid = instance.generateId("", "");
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)uuid));
    }
}

