/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.comp;

import java.util.Date;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseComponentTest;
import org.xdi.oxauth.model.ldap.TokenLdap;
import org.xdi.oxauth.model.ldap.TokenType;
import org.xdi.oxauth.service.GrantService;

public class GrantServiceTest
extends BaseComponentTest {
    private static final String TEST_TOKEN_CODE = UUID.randomUUID().toString();
    private String m_clientId;
    private GrantService m_grantService;
    private TokenLdap m_tokenLdap;

    @Parameters(value={"clientId"})
    public GrantServiceTest(String p_clientId) {
        this.m_clientId = p_clientId;
    }

    @Override
    public void beforeClass() {
        this.m_grantService = GrantService.instance();
        this.m_tokenLdap = this.createTestToken();
        this.m_grantService.persist(this.m_tokenLdap);
    }

    @Override
    public void afterClass() {
        TokenLdap t = this.m_grantService.getGrantsByCode(TEST_TOKEN_CODE);
        if (t != null) {
            this.m_grantService.remove(t);
        }
    }

    @Test
    public void testCleanUp() {
        this.m_grantService.cleanUp();
        TokenLdap t = this.m_grantService.getGrantsByCode(TEST_TOKEN_CODE);
        Assert.assertTrue((t == null ? 1 : 0) != 0);
    }

    private TokenLdap createTestToken() {
        String id = GrantService.generateGrantId();
        String dn = GrantService.buildDn((String)id, (String)this.m_clientId);
        TokenLdap t = new TokenLdap();
        t.setId(id);
        t.setDn(dn);
        t.setTokenCode(TEST_TOKEN_CODE);
        t.setTokenType(TokenType.ACCESS_TOKEN.getValue());
        t.setCreationDate(new Date());
        t.setExpirationDate(new Date());
        return t;
    }
}

