/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.comp;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.Component;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseComponentTest;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.federation.FederationTrust;
import org.xdi.oxauth.model.federation.FederationTrustStatus;
import org.xdi.oxauth.model.util.Pair;
import org.xdi.oxauth.service.FederationDataService;
import org.xdi.oxauth.service.InumService;

public class FederationServiceTest
extends BaseComponentTest {
    private String m_redirectUri;
    private FederationTrust m_trust;

    @Parameters(value={"redirectUri"})
    public FederationServiceTest(String p_redirectUri) {
        this.m_redirectUri = p_redirectUri;
    }

    @Override
    public void beforeClass() {
        InumService inumService = (InumService)Component.getInstance(InumService.class);
        Pair pair = inumService.generateNewDN(ConfigurationFactory.getBaseDn().getFederationTrust());
        this.m_trust = new FederationTrust();
        this.m_trust.setId((String)pair.getFirst());
        this.m_trust.setDn((String)pair.getSecond());
        this.m_trust.setDisplayName("Test trust1");
        this.m_trust.setFederationId("@!1111!0008!00F1!0001");
        this.m_trust.setFederationMetadataUri("https://seed.gluu.org/oxauth/seam/resource/restv1/oxauth/federationmetadata");
        this.m_trust.setRedirectUris(Arrays.asList(this.m_redirectUri));
        this.m_trust.setTrustStatus("inactive_by_checker");
        this.m_trust.setSkipAuthorization(Boolean.valueOf(true));
        this.m_trust.setScopes(Arrays.asList("inum=@!1111!0009!BC01,ou=scopes,o=@!1111,o=gluu", "inum=@!1111!0009!2B41,ou=scopes,o=@!1111,o=gluu"));
        this.getLdapManager().persist((Object)this.m_trust);
    }

    @Override
    public void afterClass() {
        if (this.m_trust != null) {
            this.getLdapManager().remove((Object)this.m_trust);
        }
    }

    @Test
    public void findTrustByRedirectURI() {
        FederationDataService service = FederationDataService.instance();
        List<String> redirectUriList = Arrays.asList(this.m_redirectUri);
        List trust = service.getTrustByAnyRedirectUri(redirectUriList, FederationTrustStatus.INACTIVE_BY_CHECKER);
        Assert.assertTrue((trust != null && StringUtils.isNotBlank((String)((FederationTrust)trust.get(0)).getFederationId()) && ((FederationTrust)trust.get(0)).getSkipAuthorization() != false ? 1 : 0) != 0);
        List noTrust = service.getTrustByAnyRedirectUri(Arrays.asList("http://no.no"), FederationTrustStatus.ACTIVE);
        Assert.assertTrue((noTrust == null || noTrust.isEmpty() ? 1 : 0) != 0);
        List all = service.getTrustByAnyRedirectUri(redirectUriList, null);
        Assert.assertTrue((all != null && StringUtils.isNotBlank((String)((FederationTrust)all.get(0)).getFederationId()) && ((FederationTrust)all.get(0)).getSkipAuthorization() != false ? 1 : 0) != 0);
    }

    @Test
    public void filterString() {
        List<String> list = Arrays.asList("http://a.com", "http://b.com");
        String filter = FederationDataService.createFilter(list);
        Assert.assertEquals((String)filter, (String)"|(oxAuthRedirectURI=http://a.com)(oxAuthRedirectURI=http://b.com)");
    }
}

