/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.comp;

import java.net.URLEncoder;
import java.util.Arrays;
import org.jboss.seam.contexts.Contexts;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseComponentTest;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.federation.FederationTrust;
import org.xdi.oxauth.model.federation.FederationTrustStatus;
import org.xdi.oxauth.model.util.Pair;
import org.xdi.oxauth.service.FederationCheckTimer;
import org.xdi.oxauth.service.InumService;
import org.xdi.oxauth.util.ServerUtil;

public class FederationIntervalCheckerTest
extends BaseComponentTest {
    private String m_redirectUri;
    private FederationTrust m_invalidFederationUrlTrust;
    private FederationTrust m_invalidRedirectUrlTrust;

    @Parameters(value={"redirectUri"})
    public FederationIntervalCheckerTest(String p_redirectUri) {
        this.m_redirectUri = p_redirectUri;
    }

    @Override
    public void beforeClass() {
        InumService inumService = (InumService)ServerUtil.instance(InumService.class);
        Pair pair1 = inumService.generateNewDN(ConfigurationFactory.getBaseDn().getFederationTrust());
        Pair pair2 = inumService.generateNewDN(ConfigurationFactory.getBaseDn().getFederationTrust());
        this.m_invalidFederationUrlTrust = new FederationTrust();
        this.m_invalidFederationUrlTrust.setId((String)pair1.getFirst());
        this.m_invalidFederationUrlTrust.setDn((String)pair1.getSecond());
        this.m_invalidFederationUrlTrust.setDisplayName("Interval checker: invalid federation url");
        this.m_invalidFederationUrlTrust.setFederationId("@!1111!0008!00F1!0001");
        this.m_invalidFederationUrlTrust.setFederationMetadataUri("https://invalid.redirect.uri.com");
        this.m_invalidFederationUrlTrust.setRedirectUris(Arrays.asList(this.m_redirectUri));
        this.m_invalidFederationUrlTrust.setStatus(FederationTrustStatus.ACTIVE);
        this.m_invalidFederationUrlTrust.setSkipAuthorization(Boolean.valueOf(true));
        this.m_invalidRedirectUrlTrust = new FederationTrust();
        this.m_invalidRedirectUrlTrust.setId((String)pair2.getFirst());
        this.m_invalidRedirectUrlTrust.setDn((String)pair2.getSecond());
        this.m_invalidRedirectUrlTrust.setDisplayName("Interval checker: invalid redirect uri");
        this.m_invalidRedirectUrlTrust.setFederationId("@!1111!0008!00F1!0001");
        this.m_invalidRedirectUrlTrust.setFederationMetadataUri("https://seed.gluu.org/oxauth/seam/resource/restv1/oxauth/federationmetadata");
        this.m_invalidRedirectUrlTrust.setRedirectUris(Arrays.asList(this.m_redirectUri, "http://invalid.redirecturi.com"));
        this.m_invalidRedirectUrlTrust.setStatus(FederationTrustStatus.ACTIVE);
        this.m_invalidRedirectUrlTrust.setSkipAuthorization(Boolean.valueOf(true));
        this.getLdapManager().persist((Object)this.m_invalidFederationUrlTrust);
        this.getLdapManager().persist((Object)this.m_invalidRedirectUrlTrust);
    }

    @Override
    public void afterClass() {
        if (this.m_invalidFederationUrlTrust != null) {
            this.getLdapManager().remove((Object)this.m_invalidFederationUrlTrust);
        }
        if (this.m_invalidRedirectUrlTrust != null) {
            this.getLdapManager().remove((Object)this.m_invalidRedirectUrlTrust);
        }
    }

    @Test
    public void invalidMetadataUri() {
        FederationCheckTimer checker = (FederationCheckTimer)Contexts.getApplicationContext().get(FederationCheckTimer.class);
        checker.cleanUpTrusts();
        FederationTrust trust = (FederationTrust)this.getLdapManager().find(FederationTrust.class, (Object)this.m_invalidFederationUrlTrust.getDn());
        Assert.assertTrue((trust.getStatus() == FederationTrustStatus.INACTIVE_BY_CHECKER ? 1 : 0) != 0);
    }

    @Test
    public void invalidRedirectUriInTrust() {
        FederationCheckTimer checker = (FederationCheckTimer)Contexts.getApplicationContext().get(FederationCheckTimer.class);
        checker.cleanUpTrusts();
        FederationTrust trust = (FederationTrust)this.getLdapManager().find(FederationTrust.class, (Object)this.m_invalidRedirectUrlTrust.getDn());
        Assert.assertTrue((trust.getRedirectUris().size() == 1 && ((String)trust.getRedirectUris().get(0)).equals(this.m_redirectUri) ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        String s = "@!1111!0008!00F1!0001";
        System.out.println(URLEncoder.encode(s));
    }
}

