/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.fido2.ws.rs.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.oxauth.fido2.ctap.AttestationConveyancePreference;
import org.gluu.oxauth.fido2.exception.Fido2RPRuntimeException;
import org.gluu.oxauth.fido2.model.auth.CredAndCounterData;
import org.gluu.oxauth.fido2.model.cert.PublicKeyCredentialDescriptor;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationData;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationEntry;
import org.gluu.oxauth.fido2.model.entry.Fido2RegistrationStatus;
import org.gluu.oxauth.fido2.persist.AuthenticationPersistenceService;
import org.gluu.oxauth.fido2.persist.RegistrationPersistenceService;
import org.gluu.oxauth.fido2.service.Base64Service;
import org.gluu.oxauth.fido2.service.ChallengeGenerator;
import org.gluu.oxauth.fido2.service.DataMapperService;
import org.gluu.oxauth.fido2.service.verifier.AuthenticatorAttestationVerifier;
import org.gluu.oxauth.fido2.service.verifier.ChallengeVerifier;
import org.gluu.oxauth.fido2.service.verifier.CommonVerifiers;
import org.gluu.oxauth.fido2.service.verifier.DomainVerifier;
import org.slf4j.Logger;
import org.xdi.oxauth.model.configuration.AppConfiguration;

@ApplicationScoped
public class AttestationService {
    @Inject
    private Logger log;
    @Inject
    private AuthenticationPersistenceService authenticationsRepository;
    @Inject
    private RegistrationPersistenceService registrationsRepository;
    @Inject
    private AuthenticatorAttestationVerifier authenticatorAttestationVerifier;
    @Inject
    private ChallengeVerifier challengeVerifier;
    @Inject
    private DomainVerifier domainVerifier;
    @Inject
    private ChallengeGenerator challengeGenerator;
    @Inject
    private CommonVerifiers commonVerifiers;
    @Inject
    private DataMapperService dataMapperService;
    @Inject
    private Base64Service base64Service;
    @Inject
    private AppConfiguration appConfiguration;

    public JsonNode options(JsonNode params) {
        this.log.info("options {}", (Object)params);
        return this.createNewRegistration(params);
    }

    public JsonNode verify(JsonNode params) {
        this.log.info("registerResponse {}", (Object)params);
        this.commonVerifiers.verifyBasicPayload(params);
        this.commonVerifiers.verifyBase64UrlString(params, "type");
        JsonNode response = params.get("response");
        JsonNode clientDataJSONNode = null;
        try {
            if (!params.get("response").hasNonNull("clientDataJSON")) {
                throw new Fido2RPRuntimeException("Client data JSON is missing");
            }
            clientDataJSONNode = this.dataMapperService.readTree(new String(this.base64Service.urlDecode(params.get("response").get("clientDataJSON").asText()), Charset.forName("UTF-8")));
            if (clientDataJSONNode == null) {
                throw new Fido2RPRuntimeException("Client data JSON is empty");
            }
        }
        catch (IOException e) {
            throw new Fido2RPRuntimeException("Can't parse message");
        }
        this.commonVerifiers.verifyClientJSON(clientDataJSONNode);
        this.commonVerifiers.verifyClientJSONTypeIsCreate(clientDataJSONNode);
        String keyId = this.commonVerifiers.verifyBase64UrlString(params, "id");
        String clientDataChallenge = this.base64Service.urlEncodeToStringWithoutPadding(this.base64Service.urlDecode(clientDataJSONNode.get("challenge").asText()));
        this.log.info("Challenge {}", (Object)clientDataChallenge);
        List<Fido2RegistrationEntry> registrationEntries = this.registrationsRepository.findAllByChallenge(clientDataChallenge);
        Fido2RegistrationEntry credentialEntryFound = (Fido2RegistrationEntry)registrationEntries.parallelStream().findAny().orElseThrow(() -> new Fido2RPRuntimeException(String.format("Can't find request with matching challenge '%s' and domain", clientDataChallenge)));
        Fido2RegistrationData credentialFound = credentialEntryFound.getRegistrationData();
        this.domainVerifier.verifyDomain(credentialFound.getDomain(), clientDataJSONNode.get("origin").asText());
        CredAndCounterData attestationData = this.authenticatorAttestationVerifier.verifyAuthenticatorAttestationResponse(response, credentialFound);
        credentialFound.setUncompressedECPoint(attestationData.getUncompressedEcPoint());
        credentialFound.setW3cAuthenticatorAttenstationResponse(response.toString());
        credentialFound.setSignatureAlgorithm(attestationData.getSignatureAlgorithm());
        credentialFound.setCounter(attestationData.getCounters());
        if (attestationData.getCredId() != null) {
            credentialFound.setPublicKeyId(attestationData.getCredId());
        } else {
            credentialFound.setPublicKeyId(keyId);
        }
        credentialFound.setType("public-key");
        credentialFound.setStatus(Fido2RegistrationStatus.registered);
        this.registrationsRepository.update(credentialEntryFound);
        ((ObjectNode)params).put("errorMessage", "");
        ((ObjectNode)params).put("status", "ok");
        return params;
    }

    private JsonNode createNewRegistration(JsonNode params) {
        String host;
        this.commonVerifiers.verifyOptions(params);
        String username = params.get("username").asText();
        String displayName = params.get("displayName").asText();
        String documentDomain = params.hasNonNull("documentDomain") ? params.get("documentDomain").asText() : this.appConfiguration.getIssuer();
        try {
            host = new URL(documentDomain).getHost();
        }
        catch (MalformedURLException e) {
            host = documentDomain;
        }
        if (params.hasNonNull("authenticatorSelection")) {
            String authenticatorSelection = params.get("authenticatorSelection").asText();
        } else {
            String authenticatorSelection = "";
        }
        this.log.info("Options {} {} {}", new Object[]{username, displayName, documentDomain});
        AttestationConveyancePreference attestationConveyancePreference = this.commonVerifiers.verifyAttestationConveyanceType(params);
        String credentialType = params.hasNonNull("credentialType") ? params.get("credentialType").asText("public-key") : "public-key";
        ObjectNode credentialCreationOptionsNode = this.dataMapperService.createObjectNode();
        String challenge = this.challengeGenerator.getChallenge();
        credentialCreationOptionsNode.put("challenge", challenge);
        this.log.info("Challenge {}", (Object)challenge);
        ObjectNode credentialRpEntityNode = credentialCreationOptionsNode.putObject("rp");
        credentialRpEntityNode.put("name", "oxAuth RP");
        credentialRpEntityNode.put("id", documentDomain);
        ObjectNode credentialUserEntityNode = credentialCreationOptionsNode.putObject("user");
        byte[] buffer = new byte[32];
        new SecureRandom().nextBytes(buffer);
        String userId = this.base64Service.urlEncodeToString(buffer);
        credentialUserEntityNode.put("id", userId);
        credentialUserEntityNode.put("name", username);
        credentialUserEntityNode.put("displayName", displayName);
        credentialCreationOptionsNode.put("attestation", attestationConveyancePreference.toString());
        ArrayNode credentialParametersArrayNode = credentialCreationOptionsNode.putArray("pubKeyCredParams");
        ObjectNode credentialParametersNode = credentialParametersArrayNode.addObject();
        if ("public-key".equals(credentialType)) {
            credentialParametersNode.put("type", "public-key");
            credentialParametersNode.put("alg", -7);
        }
        if ("FIDO".equals(credentialType)) {
            credentialParametersNode.put("type", "FIDO");
            credentialParametersNode.put("alg", -7);
        }
        credentialCreationOptionsNode.set("authenticatorSelection", params.get("authenticatorSelection"));
        List<Fido2RegistrationEntry> existingRegistrations = this.registrationsRepository.findAllByUsername(username);
        List excludedKeys = existingRegistrations.parallelStream().filter(f -> Fido2RegistrationStatus.registered.equals((Object)f.getRegistrationData().getStatus())).map(f -> this.dataMapperService.convertValue(new PublicKeyCredentialDescriptor(f.getRegistrationData().getType(), f.getRegistrationData().getPublicKeyId()), JsonNode.class)).collect(Collectors.toList());
        ArrayNode excludedCredentials = credentialCreationOptionsNode.putArray("excludeCredentials");
        excludedCredentials.addAll(excludedKeys);
        credentialCreationOptionsNode.put("status", "ok");
        credentialCreationOptionsNode.put("errorMessage", "");
        Fido2RegistrationData entity = new Fido2RegistrationData();
        entity.setUsername(username);
        entity.setUserId(userId);
        entity.setChallenge(challenge);
        entity.setDomain(host);
        entity.setW3cCredentialCreationOptions(credentialCreationOptionsNode.toString());
        entity.setAttestationConveyancePreferenceType(attestationConveyancePreference);
        entity.setStatus(Fido2RegistrationStatus.pending);
        this.registrationsRepository.save(entity);
        return credentialCreationOptionsNode;
    }
}

